<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$unit                             = esc_html__( 'sq ft', ERE_TEXT_DOMAIN );
$ere_area_unit                    = $this->get_option( 'ere_area_unit', $unit );
$ere_lot_unit                     = $this->get_option( 'ere_lot_unit', $unit );
$inspiry_auto_property_id_check   = $this->get_option( 'inspiry_auto_property_id_check', 'true' );
$inspiry_auto_property_id_pattern = $this->get_option( 'inspiry_auto_property_id_pattern', 'RH-{ID}-property' );
$inspiry_property_energy_classes  = $this->get_option( 'inspiry_property_energy_classes' );

if ( isset( $_POST['_wpnonce'] ) && wp_verify_nonce( $_POST['_wpnonce'], 'inspiry_ere_settings' ) ) {

	update_option( 'ere_area_unit', $ere_area_unit );
	update_option( 'ere_lot_unit', $ere_lot_unit );
	update_option( 'inspiry_auto_property_id_check', $inspiry_auto_property_id_check );
	update_option( 'inspiry_auto_property_id_pattern', $inspiry_auto_property_id_pattern );

	// Handling property energy classes data.
	if ( isset( $_POST['inspiry_property_energy_classes'] ) && ! empty( $_POST['inspiry_property_energy_classes'] ) ) {

		foreach ( $_POST['inspiry_property_energy_classes'] as $energy_class => $values ) {
			if ( empty( $values['name'] ) || empty( $values['color'] ) ) {
				unset( $_POST['inspiry_property_energy_classes'][ $energy_class ] );
			}
		}

		$inspiry_property_energy_classes = array_values( $_POST['inspiry_property_energy_classes'] );
		if ( is_array( $inspiry_property_energy_classes ) ) {
			update_option( 'inspiry_property_energy_classes', $inspiry_property_energy_classes );
		}
	} else {
		$inspiry_property_energy_classes = '';
		delete_option( 'inspiry_property_energy_classes' );
	}
}
?>
<div class="inspiry-ere-page-content">
    <form method="post" action="" novalidate="novalidate">

        <table class="form-table">
            <tbody>
            <tr>
                <th scope="row">
                    <label for="ere_area_unit"><?php esc_html_e( 'Area Size Unit', ERE_TEXT_DOMAIN ) ?></label>
                </th>
                <td>
                    <input name="ere_area_unit" type="text" id="ere_area_unit" value="<?php echo esc_attr( $ere_area_unit ); ?>" class="regular-text code">
                    <p class="description">
						<?php esc_html_e( 'Default: sq ft', ERE_TEXT_DOMAIN ); ?>
                    </p>
                </td>
            </tr>
            <tr>
                <th scope="row">
                    <label for="ere_lot_unit"><?php esc_html_e( 'Lot Size Unit', ERE_TEXT_DOMAIN ) ?></label>
                </th>
                <td>
                    <input name="ere_lot_unit" type="text" id="ere_lot_unit" value="<?php echo esc_attr( $ere_lot_unit ); ?>" class="regular-text code">
                    <p class="description">
						<?php esc_html_e( 'Default: sq ft', ERE_TEXT_DOMAIN ); ?>
                    </p>
                </td>
            </tr>
            </tbody>
        </table>

        <hr>

        <table class="form-table">
            <tbody>
            <tr>
                <th scope="row"><?php esc_html_e( 'Enable Auto-Generated Property ID', ERE_TEXT_DOMAIN ); ?></th>
                <td>
                    <fieldset>
                        <label>
                            <input type="radio" name="inspiry_auto_property_id_check" value="true" <?php checked( $inspiry_auto_property_id_check, 'true' ) ?>>
                            <span><?php esc_html_e( 'Enable', ERE_TEXT_DOMAIN ); ?></span>
                        </label>
                        <br>
                        <label>
                            <input type="radio" name="inspiry_auto_property_id_check" value="false" <?php checked( $inspiry_auto_property_id_check, 'false' ) ?>>
                            <span><?php esc_html_e( 'Disable', ERE_TEXT_DOMAIN ); ?></span>
                        </label>
                    </fieldset>
                </td>
            </tr>
            <tr>
                <th scope="row">
                    <label for="inspiry_auto_property_id_pattern"><?php esc_html_e( 'Auto-Generated Property ID Pattern', ERE_TEXT_DOMAIN ) ?></label>
                </th>
                <td>
                    <input name="inspiry_auto_property_id_pattern" type="text" id="inspiry_auto_property_id_pattern" value="<?php echo esc_attr( $inspiry_auto_property_id_pattern ); ?>" class="regular-text code">
                    <p class="description">
                        <strong><?php esc_html_e( 'Important: ', ERE_TEXT_DOMAIN ) ?></strong><?php esc_html_e( 'Please use {ID} in your pattern as it will be replaced by the Property ID.', ERE_TEXT_DOMAIN ); ?>
                    </p>
                </td>
            </tr>
            </tbody>
        </table>

        <hr>
        <!-- Energy Performance Classes Settings -->
        <div class="energy-classes-settings">
            <h2><?php esc_html_e( 'Energy Perofrmance Certificate Classes', ERE_TEXT_DOMAIN ); ?></h2>
            <table class="form-table">
                <tbody>
                <tr>
                    <th><?php esc_html_e( 'Class Name', ERE_TEXT_DOMAIN ); ?></th>
                    <th><?php esc_html_e( 'Class Color', ERE_TEXT_DOMAIN ); ?></th>
                    <th></th>
                    <th></th>
                </tr>
                </tbody>
                <tbody class="epc-classes-sortable">
				<?php

				if ( empty( $inspiry_property_energy_classes ) ) {
					$energy_classes = ere_epc_default_fields();
				} else {
					$energy_classes = $inspiry_property_energy_classes;
				}

				foreach ( $energy_classes as $index => $energy_class ) {
					?>
                    <tr class="epc-class draggable">
                        <td>
                            <a class="reorder-epc-class" draggable="true"></a>
                            <input type="text" class="class-name" name="inspiry_property_energy_classes[<?php echo $index; ?>][name]" value="<?php echo esc_attr( $energy_class['name'] ); ?>">
                        </td>
                        <td>
                            <input type="text" class="class-color" name="inspiry_property_energy_classes[<?php echo $index; ?>][color]" value="<?php echo esc_attr( $energy_class['color'] ); ?>">
                            <a class="remove-epc-class" href="#"><span class="dashicons dashicons-dismiss"></span></a>
                        </td>
                    </tr>
					<?php
				}
				?>
                </tbody>
            </table>
            <div class="add-epc-class-wrap">
                <a href="#" class="button button-primary add-epc-class">+ Add more</a>
            </div>
        </div>
        <div class="submit">
			<?php wp_nonce_field( 'inspiry_ere_settings' ); ?>
            <input type="submit" name="submit" id="submit" class="button button-primary" value="<?php esc_attr_e( 'Save Changes', ERE_TEXT_DOMAIN ); ?>">
        </div>
    </form>
</div>