<?php
global $settings, $rhea_add_meta_select;

$rhea_add_meta_select = array();
$property_id          = get_the_ID();

if ( ! empty( $settings['rhea_add_meta_select'] ) ) {
	$rhea_add_meta_select = $settings['rhea_add_meta_select'];
}

$settings_to_keys = array(
	'bedrooms'    => array(
		'key'     => 'REAL_HOMES_property_bedrooms',
		'icon'    => 'bed',
		'postfix' => ''
	),
	'bathrooms'   => array(
		'key'     => 'REAL_HOMES_property_bathrooms',
		'icon'    => 'shower',
		'postfix' => ''
	),
	'area'        => array(
		'key'     => 'REAL_HOMES_property_size',
		'icon'    => 'area',
		'postfix' => 'REAL_HOMES_property_size_postfix'
	),
	'garage'      => array(
		'key'     => 'REAL_HOMES_property_garage',
		'icon'    => 'icon-garage',
		'postfix' => ''
	),
	'year-built'  => array(
		'key'     => 'REAL_HOMES_property_year_built',
		'icon'    => 'icon-calendar',
		'postfix' => ''
	),
	'lot-size'    => array(
		'key'     => 'REAL_HOMES_property_lot_size',
		'icon'    => 'icon-lot',
		'postfix' => 'REAL_HOMES_property_lot_size_postfix'
	),
	'property-id' => array(
		'key'     => 'REAL_HOMES_property_id',
		'icon'    => 'icon-tag',
		'postfix' => ''
	),
);

if ( rhea_is_rvr_enabled() ) {
	$settings_to_keys['guests'] = array(
		'key'     => 'rvr_guests_capacity',
		'icon'    => 'guests-icons',
		'postfix' => ''
	);

	$settings_to_keys['min-stay'] = array(
		'key'     => 'rvr_min_stay',
		'icon'    => 'icon-min-stay',
		'postfix' => ''
	);
}

if ( ! empty( $rhea_add_meta_select ) ) {
	$meta_layout = empty( $settings['meta_layout'] ) ? '1' : $settings['meta_layout'];
	?>
    <div class="rh_prop_card_meta_wrap_stylish">
		<?php
		foreach ( $rhea_add_meta_select as $i => $meta ) {
			if ( ! empty( $meta['rhea_property_meta_display'] ) && isset( $settings_to_keys[ $meta['rhea_property_meta_display'] ] ) ) {
				rhea_stylish_meta(
					$meta['rhea_meta_repeater_label'],
					$settings_to_keys[ $meta['rhea_property_meta_display'] ]['key'],
					$settings_to_keys[ $meta['rhea_property_meta_display'] ]['icon'],
					$settings_to_keys[ $meta['rhea_property_meta_display'] ]['postfix'],
					$i + 1,
					$meta_layout
				);
			}
		}

		// Display additional fields property meta.
		do_action( 'ere_property_additional_meta_fields', $property_id, array( 'layout' => $meta_layout ) );
		?>
    </div>
	<?php
}
