<?php
/**
 * Agent/Agency Single Contact Form Widget
 *
 * @since 2.3.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RHEA_Ultra_Agent_Agency_Form_Widget extends \Elementor\Widget_Base {
	public function get_name() {
		return 'rhea-ultra-agent-form-widget';
	}

	public function get_title() {
		return esc_html__( 'RH: Agent/Agency Contact Form', RHEA_TEXT_DOMAIN );
	}

	public function get_icon() {
		return 'eicon-form-horizontal rh-ultra-widget';
	}

	public function get_categories() {
		return [ 'ultra-real-homes' ];
	}

    use RHEA_GDPR_Controls;

	protected function register_controls() {
		$this->start_controls_section(
			'basic_settings',
			[
				'label' => esc_html__( 'Basic', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'form_heading',
			[
				'label'   => esc_html__( 'Form Heading', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Contact Me', RHEA_TEXT_DOMAIN ),
			]
		);
		$this->add_control(
			'name_field_label',
			[
				'label'   => esc_html__( 'Name Field Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Name', RHEA_TEXT_DOMAIN ),
			]
		);
		$this->add_control(
			'name_field_placeholder',
			[
				'label'   => esc_html__( 'Name Field Placeholder', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Your Name', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'name_field_error_text',
			[
				'label'   => esc_html__( 'Name Field Error Text', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( '* Please provide your name', RHEA_TEXT_DOMAIN ),
			]
		);
		$this->add_control(
			'phone_field_label',
			[
				'label'   => esc_html__( 'Phone Field Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Phone', RHEA_TEXT_DOMAIN ),
			]
		);
		$this->add_control(
			'phone_field_placeholder',
			[
				'label'   => esc_html__( 'Phone Field Placeholder', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Your Phone', RHEA_TEXT_DOMAIN ),
			]
		);
		$this->add_control(
			'email_field_label',
			[
				'label'   => esc_html__( 'Email Field Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Email', RHEA_TEXT_DOMAIN ),
			]
		);
		$this->add_control(
			'email_field_placeholder',
			[
				'label'   => esc_html__( 'Email Field Placeholder', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Your Email', RHEA_TEXT_DOMAIN ),
			]
		);
		$this->add_control(
			'email_field_error_text',
			[
				'label'   => esc_html__( 'Email Field Error Text', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( '* Please provide a valid email address', RHEA_TEXT_DOMAIN ),
			]
		);
		$this->add_control(
			'message_field_label',
			[
				'label'   => esc_html__( 'Message Field Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Message', RHEA_TEXT_DOMAIN ),
			]
		);
		$this->add_control(
			'message_field_placeholder',
			[
				'label'   => esc_html__( 'Message Field Placeholder', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Your Message', RHEA_TEXT_DOMAIN ),
			]
		);
		$this->add_control(
			'message_field_error_text',
			[
				'label'   => esc_html__( 'Message Field Error Text', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( '* Please provide your message', RHEA_TEXT_DOMAIN ),
			]
		);
		$this->add_control(
			'button_text',
			[
				'label'   => esc_html__( 'Button Text', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Send Message', RHEA_TEXT_DOMAIN ),
			]
		);

        $this->add_control(
            'display-icons',
            [
                'label'     => esc_html__( 'Display Fields Icons', RHEA_TEXT_DOMAIN ),
                'type'      => \Elementor\Controls_Manager::SELECT,
                'options'   => [
                    'none'         => esc_html__( 'None', RHEA_TEXT_DOMAIN ),
                    'inline-block' => esc_html__( 'Inline', RHEA_TEXT_DOMAIN ),
                ],
                'selectors' => [
                    '{{WRAPPER}} .rh-ultra-form-field-wrapper label' => 'display: {{VALUE}};',
                ],
            ]
        );

		$this->end_controls_section();

		$this->start_controls_section(
			'sizes_spaces',
			[
				'label' => esc_html__( 'Sizes & Spaces', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'wrapper_padding',
			[
				'label'      => esc_html__( 'Wrapper Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rh-ultra-form' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);


		$this->add_responsive_control(
			'label-margins',
			[
				'label'      => esc_html__( 'Label Margin', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .rh-ultra-form-field > label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'label-padding',
			[
				'label'      => esc_html__( 'Label Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .rh-ultra-form-field > label' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'fields-margins',
			[
				'label'      => esc_html__( 'Fields Margin', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .rh-ultra-form-field-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'fields-padding',
			[
				'label'      => esc_html__( 'Fields Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors'  => [
					'{{WRAPPER}} .rh-ultra-form-field-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'button-margins',
			[
				'label'      => esc_html__( 'Button Margin', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px' ],
				'selectors'  => [
					'{{WRAPPER}} .submit-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'button-padding',
			[
				'label'      => esc_html__( 'Button Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .submit-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'colors',
			[
				'label' => esc_html__( 'Colors', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'form_heading_color',
			[
				'label'     => esc_html__( 'Heading', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-page-heading' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'form_bg_color',
			[
				'label'     => esc_html__( 'Form Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-form' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'fields_bg_color',
			[
				'label'     => esc_html__( 'Fields Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-form-field-wrapper' => 'background-color: {{VALUE}}',
					'{{WRAPPER}} .rh-ultra-field'              => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'fields_label_color',
			[
				'label'     => esc_html__( 'Fields Label Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-form-field > label' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'field-placeholder-color',
			[
				'label'     => esc_html__( 'Placeholder Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-form ::-webkit-input-placeholder' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rh-ultra-form ::-moz-placeholder'          => 'color: {{VALUE}}',
					'{{WRAPPER}} .rh-ultra-form :-ms-input-placeholder'      => 'color: {{VALUE}}',
					'{{WRAPPER}} .rh-ultra-form :-moz-placeholder'           => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'field-text-color',
			[
				'label'     => esc_html__( 'Field Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-field' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'field-icon-color',
			[
				'label'     => esc_html__( 'Field Icon', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-form-field-wrapper svg' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'field-icon-color-focused',
			[
				'label'     => esc_html__( 'Field Icon Focus', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-form-field-wrapper:focus-within svg' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'field-separator-color',
			[
				'label'     => esc_html__( 'Field Separator', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-field' => 'border-bottom-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'field-separator-color-focused',
			[
				'label'     => esc_html__( 'Field Separator Focus', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-ultra-field:focus' => 'border-bottom-color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'fields_box_shadow',
				'label'    => esc_html__( 'Fields Box Shadow', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rh-ultra-form-field-wrapper',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'typography_section',
			[
				'label' => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'heading_typography',
				'label'    => esc_html__( 'Heading', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rh-page-heading',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'label_typography',
				'label'    => esc_html__( 'Fields Label', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rh-ultra-form-field > label',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'fields_text_typography',
				'label'    => esc_html__( 'Fields Text', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rh-ultra-field',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'button_text_typography',
				'label'    => esc_html__( 'Button Text', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .submit-button',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'border_settings_section',
			[
				'label' => esc_html__( 'Border Settings', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'wrapper-border-heading',
			[
				'label'     => esc_html__( 'Wrapper Border', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'form-wrapper-border',
				'label'    => esc_html__( 'Wrapper Border', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rh-ultra-form',
			]
		);

		$this->add_responsive_control(
			'form-border-radius',
			[
				'label'      => esc_html__( 'Wrapper Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rh-ultra-form' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'field-border-heading',
			[
				'label'     => esc_html__( 'Field Border', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);


		$this->start_controls_tabs( 'tabs-view-form-fields' );
		$this->start_controls_tab(
			'fields-border-normal',
			[
				'label' => esc_html__( 'Normal', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'form-field-border',
				'label'    => esc_html__( 'Fields Border', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rh-ultra-form-field-wrapper',
			]
		);


		$this->add_responsive_control(
			'fields-border-radius',
			[
				'label'      => esc_html__( 'Fields Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rh-ultra-form-field-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'fields-border-active',
			[
				'label' => esc_html__( 'Active', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'form-field-border-active',
				'label'    => esc_html__( 'Fields Border Active', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rh-ultra-form-field-wrapper:focus-within',
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_control(
			'submit-button-heading',
			[
				'label'     => esc_html__( 'Submit Button', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_responsive_control(
			'button-border-radius',
			[
				'label'      => esc_html__( 'Button Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .submit-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);


		$this->add_control(
			'button-bg-color',
			[
				'label'     => esc_html__( 'Button Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .submit-button' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'button-border-color',
			[
				'label'     => esc_html__( 'Button Border Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .submit-button' => 'border-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'button-bg-hover-color',
			[
				'label'     => esc_html__( 'Button Background Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .submit-button:hover' => 'background-color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'button-border-hover-color',
			[
				'label'     => esc_html__( 'Button Border Hover Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .submit-button:hover' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button-text-color',
			[
				'label'     => esc_html__( 'Button Text', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .submit-button' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'button-text-hover-color',
			[
				'label'     => esc_html__( 'Button Text Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .submit-button:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_tabs();

		$this->end_controls_section();

		$this->gdpr_settings();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		$agent_id = get_the_ID();
		if ( rhea_is_preview_mode() ) {
			$agent_id = rhea_get_sample_agent_id();
		}
		if ( is_singular( 'agency' ) ) {
			$target_email = get_post_meta( $agent_id, 'REAL_HOMES_agency_email', true );
		} else {
			$target_email = get_post_meta( $agent_id, 'REAL_HOMES_agent_email', true );
		}

		if ( inspiry_get_agent_custom_form() ) {
			inspiry_agent_custom_form();
		} else if ( is_email( $target_email ) ) {
			if ( ! empty( $settings['form_heading'] ) ) {
				?>
                <h3 class="agent-contact-form-heading rh-page-heading"><?php echo esc_html( $settings['form_heading'] ) ?></h3>
				<?php
			}
			?>
            <div class="rh-ultra-form rhea-ultra-agent-form">
                <form id="agent-single-form" class="contact-form agent-contact-form" method="post" action="<?php echo esc_url( admin_url( 'admin-ajax.php' ) ); ?>">
                    <div class="rh-ultra-fields-split">
                        <div class="rh-ultra-form-field">
                            <label for="name"><?php echo esc_html( $settings['name_field_label'] ); ?></label>
                            <p class="rh-ultra-form-field-wrapper">
                                <label><?php inspiry_safe_include_svg( '/ultra/icons/user.svg', '/assets/' ); ?></label>
                                <input type="text" name="name" id="name" class="required rh-ultra-field" placeholder="<?php echo esc_attr( $settings['name_field_placeholder'] ) ?>" title="<?php echo esc_attr( $settings['name_field_error_text'] ); ?>">
                            </p>
                        </div>
                        <div class="rh-ultra-form-field">
                            <label for="number"><?php echo esc_html( $settings['phone_field_label'] ); ?></label>
                            <p class="rh-ultra-form-field-wrapper">
                                <label><?php inspiry_safe_include_svg( '/ultra/icons/phone.svg', '/assets/' ); ?></label>
                                <input type="text" name="phone" id="number" class="rh-ultra-field" placeholder="<?php echo esc_attr( $settings['phone_field_placeholder'] ) ?>">
                            </p>
                        </div>
                    </div>
                    <div class="rh-ultra-form-field">
                        <label for="email"><?php echo esc_html( $settings['email_field_label'] ); ?></label>
                        <p class="rh-ultra-form-field-wrapper">
                            <label><?php inspiry_safe_include_svg( '/ultra/icons/email.svg', '/assets/' ); ?></label>
                            <input type="text" name="email" id="email" class="email required rh-ultra-field" placeholder="<?php echo esc_attr( $settings['email_field_placeholder'] ); ?>" title="<?php echo esc_attr( $settings['email_field_error_text'] ); ?>">
                        </p>
                    </div>
                    <div class="rh-ultra-form-field">
                        <label for="message"><?php echo esc_html( $settings['message_field_label'] ); ?></label>
                        <p class="rh-ultra-form-field-wrapper rh-ultra-form-textarea">
                            <label><?php inspiry_safe_include_svg( '/ultra/icons/message.svg', '/assets/' ); ?></label>
                            <textarea cols="40" rows="6" name="message" id="message" class="required rh-ultra-field" placeholder="<?php echo esc_attr( $settings['message_field_placeholder'] ); ?>" title="<?php echo esc_attr( $settings['message_field_error_text'] ); ?>"></textarea>
                        </p>
                    </div>
					<?php
					if ( function_exists( 'ere_gdpr_agreement' ) ) {
						ere_gdpr_agreement( array(
							'id'              => 'rh_inspiry_gdpr',
							'container'       => 'p',
							'container_class' => 'rh_inspiry_gdpr',
							'title_class'     => 'gdpr-checkbox-label'
						) );
					}

					if ( class_exists( 'Easy_Real_Estate' ) ) {
						// Display reCAPTCHA if enabled and configured from customizer settings
						if ( ere_is_reCAPTCHA_configured() ) {
							$recaptcha_type = get_option( 'inspiry_reCAPTCHA_type', 'v2' );
							?>
                            <div class="rh_contact__input rh_contact__input_recaptcha inspiry-recaptcha-wrapper g-recaptcha-type-<?php echo esc_attr( $recaptcha_type ); ?>">
                                <div class="inspiry-google-recaptcha"></div>
                            </div>
							<?php
						}
					}
					?>
                    <div class="rh-ultra-submit-wrapper">
                        <input type="hidden" name="action" value="send_message_to_agent" />
                        <input type="hidden" name="agent_id" value="<?php echo esc_attr( $agent_id ); ?>">
                        <input type="hidden" name="nonce" value="<?php echo esc_attr( wp_create_nonce( 'agent_message_nonce' ) ); ?>" />
                        <input type="hidden" name="target" value="<?php echo esc_attr( antispambot( $target_email ) ); ?>">
                        <button type="submit" name="submit" class="submit-button rh-btn rh-btn-primary"><?php echo esc_html( $settings['button_text'] ); ?></button>
                        <span class="ajax-loader rh-ultra-ajax-loader"><?php inspiry_safe_include_svg( '/icons/ball-triangle.svg' ); ?></span>
                    </div>
                    <div id="error-container" class="error-container"></div>
                    <div id="message-container" class="message-container"></div>
                </form>
            </div>
			<?php
		}

	}
}
