<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RHEA_Search_Form_Widget extends \Elementor\Widget_Base {
	private $is_rvr_enabled;

	public function __construct( array $data = [], ?array $args = null ) {
		parent::__construct( $data, $args );
		$this->rhea_ui_slider_enqueue_scripts();
		$this->is_rvr_enabled = rhea_is_rvr_enabled();
	}

	public function get_name() {
		return 'rhea-search-form-widget';
	}

	public function get_title() {
		return esc_html__( 'RH: Search Form', RHEA_TEXT_DOMAIN );
	}

	public function get_icon() {
		return 'eicon-search rh-modern-widget';
	}

	public function get_categories() {
		return [ 'real-homes' ];
	}

	use RHEASearchFormSettings;
	use RHEASearchFormRadiusSettings;
	use RHEASearchFormRadioSettings;
	use RHEASearchFormFieldBorder;

	public function get_script_depends() {

		wp_register_script(
			'rvr-ultra-search-form',
			RHEA_PLUGIN_URL . 'elementor/js/search-form.js',
			[ 'elementor-frontend' ],
			RHEA_VERSION,
			true
		);

		return [
			'jquery-ui-slider',
			'rvr-ultra-search-form'
		];
	}

	public function rhea_ui_slider_enqueue_scripts() {
		wp_enqueue_script( 'jquery-ui-slider' );
		wp_enqueue_script(
			'jquery-ui-touch-punch',
			RHEA_PLUGIN_URL . 'elementor/js/jquery.ui.touch-punch.min.js',
			array( 'jquery-ui-slider' ),
			RHEA_VERSION,
			true
		);
	}

	public function get_style_depends() {

		wp_register_style( 'rvr-ultra-search-form', RHEA_PLUGIN_URL . '/elementor/css/rvr-search-form.css', array(), RHEA_VERSION );

		return [
			'rvr-ultra-search-form'
		];
	}

	public function search_template_options() {
		if ( function_exists( 'inspiry_pages' ) ) {
			$search_pages_args = array(
				'meta_query' => array(
					'relation' => 'or',
					array(
						'key'   => '_wp_page_template',
						'value' => 'elementor_header_footer',
					),
					array(
						'key'   => '_wp_page_template',
						'value' => 'elementor_canvas',
					),
					array(
						'key'   => '_wp_page_template',
						'value' => 'templates/properties-search.php',
					),
				),
			);

			return inspiry_pages( $search_pages_args );
		}
	}

	protected function register_controls() {

		$this->start_controls_section(
			'rhea_search_basic_settings',
			[
				'label' => esc_html__( 'Basic Settings', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'rhea_select_search_template',
			[
				'label'       => esc_html__( 'Select Search Template', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'If no search template is selected, "RealHomes > Customize Settings > Property Search > Properties Search Page" settings will be applied by default   ', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'options'     => $this->search_template_options(),
			]
		);

		$this->add_control(
			'rhea_top_field_count',
			[
				'label'       => esc_html__( 'Top Fields To Display', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Select number of fields to display in top bar' ),
				'type'        => \Elementor\Controls_Manager::SELECT,
				'default'     => '3',
				'options'     => array(
					'1' => esc_html__( 'One', RHEA_TEXT_DOMAIN ),
					'2' => esc_html__( 'Two', RHEA_TEXT_DOMAIN ),
					'3' => esc_html__( 'Three', RHEA_TEXT_DOMAIN ),
					'4' => esc_html__( 'Four', RHEA_TEXT_DOMAIN ),
					'5' => esc_html__( 'Five', RHEA_TEXT_DOMAIN ),
					'6' => esc_html__( 'Six', RHEA_TEXT_DOMAIN ),
					'7' => esc_html__( 'Seven', RHEA_TEXT_DOMAIN ),
					'8' => esc_html__( 'Eight', RHEA_TEXT_DOMAIN ),
					'9' => esc_html__( 'Nine', RHEA_TEXT_DOMAIN ),
				),
			]
		);

		$this->add_control(
			'rhea_default_advance_state',
			[
				'label'   => esc_html__( 'Advance Fields Default State', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'collapsed',
				'options' => array(
					'collapsed' => esc_html__( 'Collapsed', RHEA_TEXT_DOMAIN ),
					'open'      => esc_html__( 'Open', RHEA_TEXT_DOMAIN ),
					'popup'     => esc_html__( 'Popup', RHEA_TEXT_DOMAIN ),
				),
			]
		);

		$this->add_control(
			'show_labels',
			[
				'label'        => esc_html__( 'Show Labels', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$this->add_control(
			'hide_top_labels',
			[
				'label'        => esc_html__( 'Hide Top Fields Labels', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
				'condition'    => [
					'show_labels' => 'yes',
				],
			]
		);

		$this->add_control(
			'hide_collapsed_labels',
			[
				'label'        => esc_html__( 'Hide Collapsed Fields Labels', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
				'condition'    => [
					'show_labels' => 'yes',
				],
			]
		);

		$this->add_control(
			'advance_popup_text',
			[
				'label'     => esc_html__( 'Advance Search Popup Text', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => esc_html__( 'Advance Search', RHEA_TEXT_DOMAIN ),
				'condition' => [
					'rhea_default_advance_state' => 'popup',
				],
			]
		);

		$this->add_control(
			'dropdown-icon-style',
			[
				'label'   => esc_html__( 'Drop Down Icon Style', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'caret',
				'options' => array(
					'caret'   => esc_html__( 'Caret', RHEA_TEXT_DOMAIN ),
					'chevron' => esc_html__( 'Chevron', RHEA_TEXT_DOMAIN ),
				),
			]
		);

		$this->add_responsive_control(
			'chevron_margin',
			[
				'label'     => esc_html__( 'Chevron Margin', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .rhea-dropdown-style-chevron .bootstrap-select.rhea_multi_select_picker>.dropdown-toggle .caret:before'          => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .rhea-dropdown-style-chevron .bootstrap-select.rhea_multi_select_picker_location>.dropdown-toggle .caret:before' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .rhea-dropdown-style-chevron .rhea-guests-field-dropdown-box .caret::before'                                     => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition' => [
					'dropdown-icon-style' => 'chevron',
				],
			]
		);

		$this->add_responsive_control(
			'chevron_font_size',
			[
				'label'     => esc_html__( 'Chevron Font Size', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-dropdown-style-chevron .bootstrap-select.rhea_multi_select_picker>.dropdown-toggle .caret:before'          => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rhea-dropdown-style-chevron .bootstrap-select.rhea_multi_select_picker_location>.dropdown-toggle .caret:before' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rhea-dropdown-style-chevron .rhea-guests-field-dropdown-box .caret::before'                                     => 'font-size: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'dropdown-icon-style' => 'chevron',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'search_form_buttons_section',
			[
				'label' => esc_html__( 'Search Buttons', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'search_button_label',
			[
				'label'   => esc_html__( 'Search Button Text', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Search', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'rhea_search_button_position',
			[
				'label'        => esc_html__( 'Search Button At Bottom? ', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
				'condition'    => [
					'rhea_default_advance_state' => [ 'open', 'collapsed' ],
				],
			]
		);
		$this->add_control(
			'rhea_popup_search_button_position',
			[
				'label'        => esc_html__( 'Search Button At Bottom? ', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
				'condition'    => [
					'rhea_default_advance_state' => 'popup',
				],
			]
		);

		$this->add_control(
			'search_buttons_vertical_align',
			[
				'label'       => esc_html__( 'Search Button Vertical Align', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SELECT2,
				'label_block' => true,
				'options'     => array(
					'flex-start' => esc_html__( 'Top', RHEA_TEXT_DOMAIN ),
					'center'     => esc_html__( 'Center', RHEA_TEXT_DOMAIN ),
					'flex-end'   => esc_html__( 'Bottom', RHEA_TEXT_DOMAIN ),
				),
				'selectors'   => [
					'{{WRAPPER}} .rhea_buttons_top' => 'align-self: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'show_search_button_icon',
			[
				'label'        => esc_html__( 'Show Search Button Icon? ', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'rhea_button_animate',
			[
				'label'        => esc_html__( 'Animate Search Buttons? ', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);


		$this->add_control(
			'search_button_icon',
			[
				'label'     => esc_html__( 'Search Submit Button Icon', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::ICONS,
				'condition' => [
					'show_search_button_icon' => 'yes',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_search_button_icon_size',
			[
				'label'     => esc_html__( ' Search Button Icon Size (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea_search_form_wrapper .rhea_search_form_button  svg' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_search_button_padding',
			[
				'label'     => esc_html__( 'Search Button Right/Left Padding (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea_search_form_wrapper .rhea_search_form_button' => 'padding-left: {{SIZE}}{{UNIT}}; padding-right: {{SIZE}}{{UNIT}};',
				],
			]
		);


		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'fields_search_button_typography',
				'label'    => esc_html__( 'Search Button', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea_search_form_wrapper .rhea_search_form_button',
			]
		);

		$this->start_controls_tabs( 'tabs_vew_search_btn' );

		$this->start_controls_tab(
			'search_normal',
			[
				'label' => esc_html__( 'Normal', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_responsive_control(
			'rhea_search_button_bg',
			[
				'label'     => esc_html__( 'Search Button Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_search_form_button' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_search_button_text',
			[
				'label'     => esc_html__( 'Search Button Text/Icon', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_search_form_button span'         => 'color: {{VALUE}}',
					'{{WRAPPER}} .rhea_search_form_button .icon-search' => 'stroke: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'search-icon-stroke-dark',
			[
				'label'     => esc_html__( 'Icon Stroke', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_search_form_button .rh-ultra-stroke-dark' => 'stroke: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'search-icon-fill-dark',
			[
				'label'     => esc_html__( 'Icon Fill', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_search_form_button .rh-ultra-dark' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'search_icon_border',
				'label'    => esc_html__( 'Border', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rhea_search_form_wrapper .rhea_search_form_button',
			]
		);
		$this->add_responsive_control(
			'search_icon_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'body {{WRAPPER}} .rhea_search_form_wrapper .rhea_search_form_button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'search_hover',
			[
				'label' => esc_html__( 'Hover', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_responsive_control(
			'rhea_search_button_bg_hover',
			[
				'label'     => esc_html__( 'Search Button Background Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_search_form_button:hover' => 'background: {{VALUE}}',
				],
				'condition' => [
					'rhea_button_animate' => '',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_search_button_animate_hover',
			[
				'label'     => esc_html__( 'Search Button Animate Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_search_form_button.rhea-btn-primary:before' => 'background: {{VALUE}}',
				],
				'condition' => [
					'rhea_button_animate' => 'yes',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_search_button_text_hover',
			[
				'label'     => esc_html__( 'Search Button Text/Icon Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_search_form_button:hover span'         => 'color: {{VALUE}}',
					'{{WRAPPER}} .rhea_search_form_button:hover .icon-search' => 'stroke: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'search-icon-stroke-dark-hover',
			[
				'label'     => esc_html__( 'Icon Stroke Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_search_form_button:hover .rh-ultra-stroke-dark' => 'stroke: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'search-icon-fill-dark-hover',
			[
				'label'     => esc_html__( 'Icon Fill Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_search_form_button:hover .rh-ultra-dark' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'search_icon_border_hover',
				'label'    => esc_html__( 'Border', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rhea_search_form_wrapper .rhea_search_form_button:hover',
			]
		);
		$this->add_responsive_control(
			'search_icon_border_radius_hover',
			[
				'label'      => esc_html__( 'Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'body {{WRAPPER}} .rhea_search_form_wrapper .rhea_search_form_button:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_control(
			'advance_search_heading',
			[
				'label'     => esc_html__( 'Advance Search Button', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->add_control(
			'show_advance_fields',
			[
				'label'        => esc_html__( 'Show Advance Fields Button', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'rhea_advance_button_animate',
			[
				'label'        => esc_html__( 'Animate Advance Search Buttons? ', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
				'condition'    => [
					'show_advance_fields' => 'yes',
				],
			]
		);

		$this->add_control(
			'advance_search_icon',
			[
				'label' => esc_html__( 'Advance Search Button Icon', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::ICONS,
			]
		);

		$this->start_controls_tabs( 'tabs_vew_advance_search_btn' );

		$this->start_controls_tab(
			'advance_normal',
			[
				'label' => esc_html__( 'Normal', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_responsive_control(
			'rhea_advance_search_button_bg',
			[
				'label'     => esc_html__( 'Advance Search Button Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_advanced_expander' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_advance_search_button_icon',
			[
				'label'     => esc_html__( 'Advance Search Button Icon', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_advanced_expander .icon-search-plus' => 'stroke: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'advance-icon-stroke-dark',
			[
				'label'     => esc_html__( 'Icon Stroke', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_advanced_expander .rh-ultra-stroke-dark' => 'stroke: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'advance-icon-fill-dark',
			[
				'label'     => esc_html__( 'Icon Fill', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_advanced_expander .rh-ultra-dark' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'advance_search_icon_border',
				'label'    => esc_html__( 'Border', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rhea_search_form_wrapper .rhea_advanced_expander',
			]
		);
		$this->add_responsive_control(
			'advance_search_icon_border_radius',
			[
				'label'      => esc_html__( 'Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'body {{WRAPPER}} .rhea_search_form_wrapper .rhea_advanced_expander' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'advance_search_hover',
			[
				'label' => esc_html__( 'Hover', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_responsive_control(
			'rhea_advance_search_button_bg_hover',
			[
				'label'     => esc_html__( 'Advance Search Button Background Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_advanced_expander:hover' => 'background: {{VALUE}}',
				],
				'condition' => [
					'rhea_advance_button_animate' => '',
				],
			]
		);
		$this->add_responsive_control(
			'rhea_advance_search_button_animate_hover',
			[
				'label'     => esc_html__( 'Advance Search Button Animate Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_advanced_expander.rhea-btn-primary:before' => 'background: {{VALUE}}',
				],
				'condition' => [
					'rhea_advance_button_animate' => 'yes',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_search_button_icon_hover',
			[
				'label'     => esc_html__( 'Advance Search Button Icon Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_advanced_expander:hover .icon-search-plus' => 'stroke: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'advance-icon-stroke-dark-hover',
			[
				'label'     => esc_html__( 'Icon Stroke Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_advanced_expander:hover .rh-ultra-stroke-dark' => 'stroke: {{VALUE}}',
				],
			]
		);


		$this->add_responsive_control(
			'advance-icon-fill-dark-hover',
			[
				'label'     => esc_html__( 'Icon Fill Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_advanced_expander:hover .rh-ultra-dark' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'advance_search_icon_border_hover',
				'label'    => esc_html__( 'Border', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rhea_search_form_wrapper .rhea_advanced_expander:hover',
			]
		);
		$this->add_responsive_control(
			'advance_search_icon_border_radius_hover',
			[
				'label'      => esc_html__( 'Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'body {{WRAPPER}} .rhea_search_form_wrapper .rhea_advanced_expander:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_responsive_control(
			'rhea_search_expander_icon_size',
			[
				'label'     => esc_html__( 'Advance Fields Button Icon Size (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea_search_form_wrapper .rhea_advanced_expander svg' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_expander_button_padding',
			[
				'label'          => esc_html__( 'Advance Button Right/Left Padding (px)', RHEA_TEXT_DOMAIN ),
				'type'           => \Elementor\Controls_Manager::SLIDER,
				'range'          => [
					'px' => [
						'min' => 0,
						'max' => 300,
					],
				],
				'tablet_default' => [
					'size' => 40,
					'unit' => 'px',
				],
				'mobile_default' => [
					'size' => 30,
					'unit' => 'px',
				],
				'selectors'      => [
					'{{WRAPPER}} .rhea_search_form_wrapper .rhea_advanced_expander' => 'padding-left: {{SIZE}}{{UNIT}}; padding-right: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'search_button_divider',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

		$this->add_responsive_control(
			'rhea_search_button_width',
			[
				'label'       => esc_html__( 'Search Bottom Buttons width (%)', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Search Button width (% Recommended when search button is set at bottom or on tablet/mobiles screens) ', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SLIDER,
				'size_units'  => [ 'px', '%', 'em' ],
				'range'       => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors'   => [
					'{{WRAPPER}} .rhea_buttons_bottom .rhea_search_form_button' => 'max-width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_search_bottom_button_padding',
			[
				'label'      => esc_html__( 'Search Bottom Buttons Wrapper Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'body {{WRAPPER}} .rhea_search_form_wrapper .rhea_buttons_bottom' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_search_button_gap',
			[
				'label'     => esc_html__( 'Search Buttons Gap (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea_search_form_wrapper .rhea_search_button_wrapper' => 'column-gap: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'rhea_search_fields_sorting',
			[
				'label' => esc_html__( 'Search Fields Sorting', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'rhea_search_select_sort',
			[
				'label' => esc_html__( 'Control Name', RHEA_TEXT_DOMAIN ),
				'type'  => 'rhea-select-unit-control-modern',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'rhea_search_typo_section',
			[
				'label' => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'fields_typography_labels',
				'label'    => esc_html__( 'Search Fields Labels', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' =>
					'{{WRAPPER}} .rhea_fields_labels',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'fields_typography',
				'label'    => esc_html__( 'Search Fields', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' =>
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker > .dropdown-toggle, 
					{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker_location > .dropdown-toggle,
					{{WRAPPER}} .rhea-guests-field-dropdown,
                    {{WRAPPER}} .rhea_search_form_wrapper .rhea_prop_search__option input[type="text"]',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'        => 'fields_radio_typography',
				'label'       => esc_html__( 'Search Radio Fields', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'If radio fields are enabled for bedrooms, bathrooms or garages.', RHEA_TEXT_DOMAIN ),
				'global'      => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector'    => '{{WRAPPER}} .rhea-radio-fields-wrapper .rhea-radio-field-label',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'fields_dropdown_typography',
				'label'    => esc_html__( 'Search Fields Dropdown', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker .dropdown-menu li a,
				               {{WRAPPER}} .bootstrap-select.rhea_multi_select_picker_location .dropdown-menu li a',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'      => 'guests_fields_dropdown_typography',
				'label'     => esc_html__( 'Guests Fields Dropdown Title', RHEA_TEXT_DOMAIN ),
				'global'    => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector'  => '{{WRAPPER}} .rvr-counter-field .title',
				'condition' => [
					'guests_field_type' => 'guest-types',
				],
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'      => 'guests_fields_dropdown_age_typography',
				'label'     => esc_html__( 'Guests Fields Dropdown Age Limit', RHEA_TEXT_DOMAIN ),
				'global'    => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector'  => '{{WRAPPER}} .rvr-counter-field .limit',
				'condition' => [
					'guests_field_type' => 'guest-types',
				],
			]
		);


		$this->add_responsive_control(
			'rhea_select_deselect_icon_size',
			[
				'label'     => esc_html__( 'Drop Down Select/Deselect All Icons Size', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea_search_form_wrapper .rhea_select_bs_buttons svg' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'more_features_button_typography',
				'label'    => esc_html__( 'More Feature Button', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea_open_more_features',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'more_features_fields_typography',
				'label'    => esc_html__( 'More Feature Checkbox Fields', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea-more-options-wrapper label',
			]
		);

		$this->add_responsive_control(
			'more_features_fields_checkbox_size',
			[
				'label'     => esc_html__( 'Feature Checkbox Size (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-more-options-wrapper label:before' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'more_features_checkbox_typography',
				'label'    => esc_html__( 'More Feature Checkbox Checked', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea-more-options-wrapper label:before',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'ajax_ph_input_typo',
				'label'    => esc_html__( 'Ajax based location field Input ', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .bs-searchbox .form-control',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'ajax_no_result_typo',
				'label'    => esc_html__( 'Ajax no result text', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .bootstrap-select .no-results',
			]
		);


		$this->end_controls_section();


		$this->start_controls_section(
			'rhea_search_form_sizes',
			[
				'label' => esc_html__( 'Sizes & Spaces', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'rhea_pop_max_width',
			[
				'label'     => esc_html__( 'Popup Max Width', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 100,
						'max' => 1000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-search-popup>div' => 'max-width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'rhea_default_advance_state' => 'popup',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_search_outer_border_radius',
			[
				'label'      => esc_html__( 'Search Form Wrapper Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea_search_form_wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_search_outer_padding',
			[
				'label'      => esc_html__( 'Search Form Wrapper Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea_search_form_wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_search_inner_border_radius',
			[
				'label'      => esc_html__( 'Search Form Inner Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-search-form-frame' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_top_wrapper_padding',
			[
				'label'      => esc_html__( 'Top Fields Wrapper Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea_top_search_fields ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_collapsed_wrapper_padding',
			[
				'label'      => esc_html__( 'Collapsed Fields Wrapper Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea_collapsed_search_fields' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_fields_height',
			[
				'label'     => esc_html__( 'Fields Heights (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 30,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea_search_form_wrapper .rhea_advanced_expander'                      => 'height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rhea_search_form_wrapper .rhea_search_form_button'                     => 'height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker > .dropdown-toggle'          => 'height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker_location > .dropdown-toggle' => 'height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rhea_search_form_wrapper .rhea_prop_search__option input[type="text"]' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rhea-guests-field-dropdown'                                            => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_fields_border_radius',
			[
				'label'     => esc_html__( 'Fields Border Radius (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea_search_form_wrapper .rhea_advanced_expander'                      => 'border-radius: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rhea_search_form_wrapper .rhea_search_form_button'                     => 'border-radius: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker > .dropdown-toggle'          => 'border-radius: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker_location > .dropdown-toggle' => 'border-radius: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rhea_search_form_wrapper .rhea_prop_search__option input[type="text"]' => 'border-radius: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rhea-guests-field-dropdown'                                            => 'border-radius: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rhea_radius_slider_field_inner'                                        => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);


		$this->add_responsive_control(
			'rhea_advance_top_fields_width',
			[
				'label'          => esc_html__( 'Top Bar Fields Width (%)', RHEA_TEXT_DOMAIN ),
				'description'    => esc_html__( 'Width can be set individually for default fields from Content tab', RHEA_TEXT_DOMAIN ),
				'type'           => \Elementor\Controls_Manager::SLIDER,
				'size_units'     => [ '%', 'px' ],
				'range'          => [
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'mobile_default' => [
					'size' => 100,
					'unit' => '%',
				],
				'selectors'      => [
					'{{WRAPPER}} .rhea_top_search_box .rhea_prop_search__option' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_advance_fields_width',
			[
				'label'          => esc_html__( 'Collapsed Fields Width (%)', RHEA_TEXT_DOMAIN ),
				'description'    => esc_html__( 'Width can be set individually for default fields from Content tab. (Note: These changes will not effect on Min Max Price Slider. For that go to Content > Min MAx Price)', RHEA_TEXT_DOMAIN ),
				'type'           => \Elementor\Controls_Manager::SLIDER,
				'size_units'     => [ '%', 'px' ],
				'range'          => [
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'tablet_default' => [
					'size' => 33.333,
					'unit' => '%',
				],
				'mobile_default' => [
					'size' => 100,
					'unit' => '%',
				],
				'selectors'      => [
					'{{WRAPPER}} .rhea_collapsed_search_fields_inner .rhea_prop_search__option:not(.rhea_price_slider_field)' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);


		$this->add_responsive_control(
			'rhea_popup_search_button_padding',
			[
				'label'     => esc_html__( 'Search Popup Right/Left Padding (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-search-popup .rhea_search_form_button' => 'padding-left: {{SIZE}}{{UNIT}}; padding-right: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'rhea_default_advance_state' => 'popup',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_popup_search_button_width',
			[
				'label'       => esc_html__( 'Search PopUp Button Width (%)', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Search Button width (% Recommended when search button is set at bottom or on tablet/mobiles screens) ', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SLIDER,
				'size_units'  => [ 'px', '%', 'em' ],
				'range'       => [
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors'   => [
					'{{WRAPPER}} .rhea-search-popup .rhea_search_form_button' => 'max-width: {{SIZE}}{{UNIT}};',
				],
				'condition'   => [
					'rhea_default_advance_state' => 'popup',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_dropdown_padding',
			[
				'label'      => esc_html__( 'Search Form Dropdown List Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker .dropdown-menu li a'          => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker_location .dropdown-menu li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_fields_border_size',
			[
				'label'      => esc_html__( 'Fields Border Size', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker > .dropdown-toggle'          => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker_location > .dropdown-toggle' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .rhea_search_form_wrapper .rhea_prop_search__option input[type="text"]' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_select_deselect_box_height',
			[
				'label'     => esc_html__( 'Drop Down Select/Deselect Box Height', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker .dropdown-menu .btn-block button'          => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker_location .dropdown-menu .btn-block button' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker .form-control'                             => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker_location .form-control'                    => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_select_deselect_box_border',
			[
				'label'      => esc_html__( 'Drop Down Select/Deselect Box Border', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker .dropdown-menu .btn-block'          => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker_location .dropdown-menu .btn-block' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker .form-control'                      => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker_location .form-control'             => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_select_deselect_box_border_radius',
			[
				'label'      => esc_html__( 'Drop Down Select/Deselect Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker .dropdown-menu .btn-block'          => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker_location .dropdown-menu .btn-block' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker .form-control'                      => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker_location .form-control'             => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'live_search_padding',
			[
				'label'      => esc_html__( 'Drop Down Live Search Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .bs-searchbox' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'rhea_dropdown_items_in',
			[
				'label'   => esc_html__( 'Drop Down List Height', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::NUMBER,
				'min'     => 3,
				'max'     => 15,
				'step'    => .5,
				'default' => 5.5,
			]

		);

		$this->add_control(
			'rhea_dropdown_border_radius',
			[
				'label'      => esc_html__( 'Drop Down Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker.open .dropdown-menu'     => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker_location>.dropdown-menu' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]

		);

		$this->add_responsive_control(
			'top-fields-margin-bottom',
			[
				'label'      => esc_html__( 'Top Fields Wrapper Margin', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea_top_search_fields .rhea_prop_search__option'   => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					'{{WRAPPER}} .rhea_top_search_fields .rhea_search_button_wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_top_horizontal_fields_spacings',
			[
				'label'     => esc_html__( 'Top Fields Horizontal Spacing (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea_search_form_wrapper  .rhea_top_search_fields .rhea_prop_search__option'   => 'padding-left: {{SIZE}}{{UNIT}}; padding-right: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rhea_search_form_wrapper  .rhea_top_search_fields .rhea_search_button_wrapper' => 'padding-left: {{SIZE}}{{UNIT}}; padding-right: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rhea_search_form_wrapper .rhea-search-form-frame .rhea_top_search_fields'      => 'margin-left: -{{SIZE}}{{UNIT}}; margin-right: -{{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_horizontal_fields_spacings',
			[
				'label'     => esc_html__( 'Fields Horizontal Spacing (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea_search_form_wrapper .rhea_prop_search__option'   => 'padding-left: {{SIZE}}{{UNIT}}; padding-right: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rhea_search_form_wrapper .rhea_search_button_wrapper' => 'padding-left: {{SIZE}}{{UNIT}}; padding-right: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rhea_search_form_wrapper .rhea_top_search_fields'     => 'margin-left: -{{SIZE}}{{UNIT}}; margin-right: -{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rhea_collapsed_search_fields_inner'                   => 'margin-left: -{{SIZE}}{{UNIT}}; margin-right: -{{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_labels_margin_bottom',
			[
				'label'     => esc_html__( 'Labels Margin Bottom (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea_fields_labels' => 'margin-bottom: {{SIZE}}{{UNIT}};'

				],
			]
		);

		$this->add_responsive_control(
			'rhea_vertical_fields_spacings',
			[
				'label'     => esc_html__( 'Fields Rows Gap (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea_collapsed_search_fields_inner' => 'row-gap: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rhea_top_search_box'                => 'row-gap: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_popup_vertical_fields_spacings',
			[
				'label'     => esc_html__( 'Popup Fields Margin Bottom (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea_search_form_wrapper .rhea_advance_fields_popup .rhea_prop_search__option' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_horizontal_features_spacings',
			[
				'label'     => esc_html__( 'More Features Horizontal Spacing (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-more-options-wrapper .rhea-option-bar' => 'margin-left: {{SIZE}}{{UNIT}}; margin-right: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rhea-more-options-wrapper'                  => 'margin-left: -{{SIZE}}{{UNIT}}; margin-right: -{{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_features_border_radius',
			[
				'label'     => esc_html__( 'More Features Border Radius', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-more-options-wrapper label:before' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_vertical_features_spacings',
			[
				'label'     => esc_html__( 'More Features Margin Bottom (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-more-options-wrapper .rhea-option-bar' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'more_feature_text_margin',
			[
				'label'      => esc_html__( 'More Features Text Margin', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea_open_more_features' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);


		$this->end_controls_section();

		$this->start_controls_section(
			'rhea_search_form_colors',
			[
				'label' => esc_html__( 'Colors', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]

		);

		$this->add_control(
			'rhea_search_form_bg',
			[
				'label'     => esc_html__( 'Search Form Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_search_form_wrapper' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'rhea_search_form_inner_bg',
			[
				'label'     => esc_html__( 'Search Form Inner Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-search-form-frame' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'rhea_search_form_collapse_bg',
			[
				'label'     => esc_html__( 'Search Form Advance Wrapper Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_collapsed_search_fields' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'rhea_fields_border_color',
			[
				'label'     => esc_html__( 'Fields Border Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker > .dropdown-toggle'          => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker_location > .dropdown-toggle' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .rhea_search_form_wrapper .rhea_prop_search__option input[type="text"]' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .rhea_price_slider_wrapper'                                             => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .rhea-guests-field-dropdown'                                            => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .rhea-radio-field-label:before'                                         => 'border-color: {{VALUE}}',

				],
			]
		);

		$this->add_control(
			'rhea_fields_bg_color',
			[
				'label'     => esc_html__( 'Fields Background Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker > .dropdown-toggle'          => 'background: {{VALUE}}',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker_location > .dropdown-toggle' => 'background: {{VALUE}}',
					'{{WRAPPER}} .rhea_search_form_wrapper .rhea_prop_search__option input[type="text"]' => 'background: {{VALUE}}',
					'{{WRAPPER}} .rhea_price_slider_wrapper'                                             => 'background: {{VALUE}}',
					'{{WRAPPER}} .rhea-guests-field-dropdown'                                            => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'rhea_top_fields_border_color',
			[
				'label'     => esc_html__( 'Top Fields Border Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_top_search_box .bootstrap-select.rhea_multi_select_picker > .dropdown-toggle'          => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .rhea_top_search_box .bootstrap-select.rhea_multi_select_picker_location > .dropdown-toggle' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .rhea_search_form_wrapper .rhea_top_search_box .rhea_prop_search__option input[type="text"]' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .rhea_top_search_box .rhea_price_slider_wrapper'                                             => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .rhea_top_search_box .rhea-guests-field-dropdown'                                            => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'rhea_top_fields_bg_color',
			[
				'label'     => esc_html__( 'Top Fields Background Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_top_search_box .bootstrap-select.rhea_multi_select_picker > .dropdown-toggle'          => 'background: {{VALUE}}',
					'{{WRAPPER}} .rhea_top_search_box .bootstrap-select.rhea_multi_select_picker_location > .dropdown-toggle' => 'background: {{VALUE}}',
					'{{WRAPPER}} .rhea_search_form_wrapper .rhea_top_search_box .rhea_prop_search__option input[type="text"]' => 'background: {{VALUE}}',
					'{{WRAPPER}} .rhea_top_search_box .rhea_price_slider_wrapper'                                             => 'background: {{VALUE}}',
					'{{WRAPPER}} .rhea_top_search_box .rhea-guests-field-dropdown'                                            => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'rhea_fields_label_color',
			[
				'label'     => esc_html__( 'Fields Label Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_fields_labels' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'rhea_fields_text_color',
			[
				'label'     => esc_html__( 'Fields Text Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker > .dropdown-toggle'                                      => 'color: {{VALUE}}',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker_location > .dropdown-toggle'                             => 'color: {{VALUE}}',
					'{{WRAPPER}} .rhea_search_form_wrapper .rhea_prop_search__option input[type="text"]:not(.rhea-guests-cat-field)' => 'color: {{VALUE}}',
					'{{WRAPPER}} .rhea_search_form_wrapper ::placeholder'                                                            => 'color: {{VALUE}}',
					'{{WRAPPER}} .rhea_search_form_wrapper ::-ms-input-placeholder'                                                  => 'color: {{VALUE}}',
					'{{WRAPPER}} .bs-searchbox .form-control'                                                                        => 'color: {{VALUE}}',
					'{{WRAPPER}} .rhea_search_form_wrapper ::-webkit-input-placeholder'                                              => 'color: {{VALUE}}',
					'{{WRAPPER}} .rhea_search_form_wrapper .rhea_prop_search__option .rhea_price_slider_wrapper .rhea_price_label'   => 'color: {{VALUE}}',
					'{{WRAPPER}} .rhea_price_slider_wrapper .rhea_price_range'                                                       => 'color: {{VALUE}}',
					'{{WRAPPER}} .rhea-guests-field-dropdown'                                                                        => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'rhea_fields_caret_color',
			[
				'label'     => esc_html__( 'Fields Caret Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker > 
					.dropdown-toggle .caret, .bootstrap-select.rhea_multi_select_picker_location > .dropdown-toggle .caret'                            => 'border-top-color: {{VALUE}}',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker.dropup > 
					.dropdown-toggle .caret, .bootstrap-select.rhea_multi_select_picker_location.dropup > .dropdown-toggle .caret' => 'border-bottom-color: {{VALUE}}',
					'{{WRAPPER}} .rhea-dropdown-style-caret .rhea-guests-field-dropdown-box .caret'                                                    => 'border-top-color: {{VALUE}}',
				],
				'condition' => [
					'dropdown-icon-style' => 'caret',
				],
			]
		);

		$this->add_control(
			'rhea_fields_chevron_color',
			[
				'label'     => esc_html__( 'Fields Chevron Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-dropdown-style-chevron .bootstrap-select.rhea_multi_select_picker>.dropdown-toggle .caret:before'          => 'color: {{VALUE}};',
					'{{WRAPPER}} .rhea-dropdown-style-chevron .bootstrap-select.rhea_multi_select_picker_location>.dropdown-toggle .caret:before' => 'color: {{VALUE}};',
					'{{WRAPPER}} .rhea-dropdown-style-chevron .rhea-guests-field-dropdown-box .caret::before'                                     => 'color: {{VALUE}};',
				],
				'condition' => [
					'dropdown-icon-style' => 'chevron',
				],
			]
		);


		$this->add_control(
			'rhea_dropdown_bg_color',
			[
				'label'     => esc_html__( 'Dropdown Background Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker .dropdown-menu'          => 'background: {{VALUE}}',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker_location .dropdown-menu' => 'background: {{VALUE}}',
					'{{WRAPPER}} .bootstrap-select .no-results'                                      => 'background: {{VALUE}}',
					'{{WRAPPER}} .rhea-rvr-guests-fields-wrapper'                                    => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'rhea_dropdown_text_color',
			[
				'label'     => esc_html__( 'Dropdown Text Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker .dropdown-menu li a'             => 'color: {{VALUE}}',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker_location .dropdown-menu li a'    => 'color: {{VALUE}}',
					'{{WRAPPER}} .bootstrap-select .no-results'                                              => 'color: {{VALUE}}',
					'{{WRAPPER}} .rhea-rvr-guests-fields-wrapper span'                                       => 'color: {{VALUE}}',
					'{{WRAPPER}} .rhea_search_form_wrapper .rhea_prop_search__option .rhea-guests-cat-field' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'rhea_dropdown_text_selected_color',
			[
				'label'     => esc_html__( 'Dropdown Text Select/Hover Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker .dropdown-menu li.selected a'          => 'color: {{VALUE}}',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker_location .dropdown-menu li.selected a' => 'color: {{VALUE}}',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker .dropdown-menu li:hover a'             => 'color: {{VALUE}}',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker_location .dropdown-menu li:hover a'    => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'rhea_dropdown_bg_selected_color',
			[
				'label'     => esc_html__( 'Dropdown Background Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker .dropdown-menu li.selected'          => 'background: {{VALUE}}',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker_location .dropdown-menu li.selected' => 'background: {{VALUE}}',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker .dropdown-menu li:hover'             => 'background: {{VALUE}}',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker_location .dropdown-menu li:hover'    => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'rhea_dropdown_select_deselect_border_color',
			[
				'label'     => esc_html__( 'Dropdown Buttons and Ajax placeholder Border', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker .dropdown-menu .btn-block'          => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker_location .dropdown-menu .btn-block' => 'border-color: {{VALUE}}',
					'{{WRAPPER}} .bs-searchbox .form-control'                                                   => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'rhea_dropdown_select_deselect_color',
			[
				'label'     => esc_html__( 'Dropdown Buttons Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_search_form_wrapper .rhea_select_bs_buttons.rhea_bs_select svg'         => 'fill: {{VALUE}}',
					'{{WRAPPER}} .rhea_search_form_wrapper .rhea_select_bs_buttons.rhea_bs_deselect .rhea_des' => 'stroke: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'rhea_dropdown_select_deselect_bg_color',
			[
				'label'     => esc_html__( 'Dropdown Buttons Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker .dropdown-menu .btn-block button'          => 'background: {{VALUE}}',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker_location .dropdown-menu .btn-block button' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'rhea_dropdown_select_deselect_hover_color',
			[
				'label'     => esc_html__( 'Dropdown Buttons Hover Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_search_form_wrapper .actions-btn:hover .rhea_select_bs_buttons.rhea_bs_select svg'         => 'fill: {{VALUE}}',
					'{{WRAPPER}} .rhea_search_form_wrapper .actions-btn:hover .rhea_select_bs_buttons.rhea_bs_deselect .rhea_des' => 'stroke: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'rhea_dropdown_select_deselect_hover_bg_color',
			[
				'label'     => esc_html__( 'Dropdown Buttons Hover Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker .dropdown-menu .btn-block button:hover'          => 'background: {{VALUE}}',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker_location .dropdown-menu .btn-block button:hover' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'rhea_search_form_features',
			[
				'label'     => esc_html__( 'Search Form Features Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-more-options-mode-container' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'rhea_search_form_btn_features',
			[
				'label'     => esc_html__( 'More Features Button Text Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_open_more_features' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'rhea_search_form_btn_hover_features',
			[
				'label'     => esc_html__( 'More Features Button Open/Hover Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_open_more_features:hover'              => 'color: {{VALUE}}',
					'{{WRAPPER}} .rhea_open_more_features.rhea_features_open' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'rhea_search_form_features_color',
			[
				'label'     => esc_html__( 'Features Text Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-more-options-wrapper .rhea-option-bar' => 'color: {{VALUE}}',
				],
			]
		);
		$this->add_control(
			'rhea_search_form_features_hover_color',
			[
				'label'     => esc_html__( 'Features Text Hover Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-more-options-wrapper .rhea-option-bar:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'features_checkbox_icon_checked_color',
			[
				'label'     => esc_html__( 'Features CheckBox Icon Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-more-options-wrapper input:checked+label:before' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'features_checkbox_border_color',
			[
				'label'     => esc_html__( 'Features CheckBox Border Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-more-options-wrapper label:before' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'features_checkbox_border_checked_color',
			[
				'label'     => esc_html__( 'Features CheckBox Border Checked Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-more-options-wrapper input:checked+label:before' => 'border-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'features_checkbox_bg_color',
			[
				'label'     => esc_html__( 'Features CheckBox Background Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-more-options-wrapper label:before' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'features_checkbox_bg_checked_color',
			[
				'label'     => esc_html__( 'Features CheckBox Background Checked Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-more-options-wrapper input:checked+label:before' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();


		if ( $this->is_rvr_enabled ) {
			$this->start_controls_section(
				'rhea_calender_styles_section',
				[
					'label' => esc_html__( 'Vacation Rental Calender Styles', RHEA_TEXT_DOMAIN ),
					'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
				]
			);
			$this->add_control(
				'table_cel_hover_color',
				[
					'label'     => esc_html__( 'Table Cell Hover Background', RHEA_TEXT_DOMAIN ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} div.daterangepicker td:hover'           => 'background: {{VALUE}}',
						'{{WRAPPER}} div.daterangepicker th.available:hover' => 'background: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'booking_dates_color',
				[
					'label'     => esc_html__( 'Booking Dates Selection Background', RHEA_TEXT_DOMAIN ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} div.daterangepicker td.active'       => 'background: {{VALUE}}',
						'{{WRAPPER}} div.daterangepicker td.active:hover' => 'background: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'booking_dates_border_color',
				[
					'label'     => esc_html__( 'Booking Dates Selection Border', RHEA_TEXT_DOMAIN ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} div.daterangepicker td.active'       => 'border-color: {{VALUE}}',
						'{{WRAPPER}} div.daterangepicker td.active:hover' => 'border-color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'booking_dates_range_color',
				[
					'label'     => esc_html__( 'Booking Dates Range Background', RHEA_TEXT_DOMAIN ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} .daterangepicker td.in-range' => 'background: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'table_month_color',
				[
					'label'     => esc_html__( 'Table Month Color', RHEA_TEXT_DOMAIN ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} div.daterangepicker th.month' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'table_head_color',
				[
					'label'     => esc_html__( 'Table Head Color', RHEA_TEXT_DOMAIN ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} div.daterangepicker th:not(.month)' => 'color: {{VALUE}}',
					],
				]
			);
			$this->add_control(
				'table_cell_color',
				[
					'label'     => esc_html__( 'Table Cell Color', RHEA_TEXT_DOMAIN ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} div.daterangepicker td' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'booking_cell_active_color',
				[
					'label'     => esc_html__( 'Booking Dates Selection Text Color', RHEA_TEXT_DOMAIN ),
					'type'      => \Elementor\Controls_Manager::COLOR,
					'selectors' => [
						'{{WRAPPER}} div.daterangepicker td.active'       => 'color: {{VALUE}}',
						'{{WRAPPER}} div.daterangepicker td.active:hover' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_responsive_control(
				'calender_border_radius',
				[
					'label'     => esc_html__( 'Wrapper Border Radius', RHEA_TEXT_DOMAIN ),
					'type'      => \Elementor\Controls_Manager::SLIDER,
					'range'     => [
						'px' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} .daterangepicker' => 'border-radius: {{SIZE}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'calender_cell_border_radius',
				[
					'label'     => esc_html__( 'Date Cell Border Radius', RHEA_TEXT_DOMAIN ),
					'type'      => \Elementor\Controls_Manager::SLIDER,
					'range'     => [
						'px' => [
							'min' => 0,
							'max' => 100,
						],
					],
					'selectors' => [
						'{{WRAPPER}} div.daterangepicker td'           => 'border-radius: {{SIZE}}{{UNIT}} !important;',
						'{{WRAPPER}} div.daterangepicker th.available' => 'border-radius: {{SIZE}}{{UNIT}} !important;',
					],
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Box_Shadow::get_type(),
				[
					'name'     => 'calender_frame_box_shadow',
					'label'    => esc_html__( 'Box Shadow', RHEA_TEXT_DOMAIN ),
					'selector' => 'body .daterangepicker',
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'table_head_month_tpography',
					'label'    => esc_html__( 'Table Month', RHEA_TEXT_DOMAIN ),
					'selector' => '{{WRAPPER}} div.daterangepicker th.month',
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'table_head_tpography',
					'label'    => esc_html__( 'Table Head', RHEA_TEXT_DOMAIN ),
					'selector' => '{{WRAPPER}} div.daterangepicker th:not(.month)',
				]
			);

			$this->add_group_control(
				\Elementor\Group_Control_Typography::get_type(),
				[
					'name'     => 'table_cell_tpography',
					'label'    => esc_html__( 'Table Cell', RHEA_TEXT_DOMAIN ),
					'selector' => '{{WRAPPER}} div.daterangepicker td',
				]
			);

			$this->end_controls_section();
		}


		$this->start_controls_section(
			'rhea_dropdown_scroll_section',
			[
				'label' => esc_html__( 'Dropdown List Scroll Styles', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'rhea_dropdown_scroll_size',
			[
				'label'      => esc_html__( 'Scroll Width (px)', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ '%', 'px' ],
				'range'      => [
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker.open .dropdown-menu ::-webkit-scrollbar'          => 'width: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker_location.open .dropdown-menu ::-webkit-scrollbar' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'rhea_dropdown_scroll_thumb',
			[
				'label'     => esc_html__( 'Scroll Thumb Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker.open .dropdown-menu ::-webkit-scrollbar-thumb'          => 'background-color: {{VALUE}}; outline-color: {{VALUE}}',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker_location.open .dropdown-menu ::-webkit-scrollbar-thumb' => 'background-color: {{VALUE}}; outline-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'rhea_dropdown_scroll_track',
			[
				'label'     => esc_html__( 'Scroll Track Box Shadow', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker.open .dropdown-menu ::-webkit-scrollbar-track'          => 'box-shadow: {{VALUE}}; -webkit-box-shadow: {{VALUE}}',
					'{{WRAPPER}} .bootstrap-select.rhea_multi_select_picker_location.open .dropdown-menu ::-webkit-scrollbar-track' => 'box-shadow: {{VALUE}}; -webkit-box-shadow: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'top_tabs_settings',
			[
				'label' => esc_html__( 'Top Tabs Layout Styles', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'tabs_align',
			[
				'label'     => esc_html__( 'Alignment', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::CHOOSE,
				'options'   => [
					'start'  => [
						'title' => esc_html__( 'left', RHEA_TEXT_DOMAIN ),
						'icon'  => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__( 'Center', RHEA_TEXT_DOMAIN ),
						'icon'  => 'eicon-text-align-center',
					],
					'end'    => [
						'title' => esc_html__( 'Right', RHEA_TEXT_DOMAIN ),
						'icon'  => 'eicon-text-align-right',
					],
				],
				'default'   => 'center',
				'selectors' => [
					'{{WRAPPER}} .rhea-search-top-tabs-wrapper' => 'justify-content: {{VALUE}};',
					'{{WRAPPER}} .rhea-search-top-tabs-box'     => 'justify-content: {{VALUE}};',
				],
			]
		);


		$this->add_responsive_control(
			'top_tabs_wrapper_padding',
			[
				'label'      => esc_html__( 'Taps Wrapper Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-search-top-tabs-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'top_tabs_frame_padding',
			[
				'label'      => esc_html__( 'Tabs Frame Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-form-tabs-enable' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'tabs-frame-border',
				'label'    => esc_html__( 'Tabs Frame Border', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rhea-form-tabs-enable',
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'frame_box_shadow',
				'label'    => esc_html__( 'Frame Box Shadow', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rhea-form-tabs-enable',
			]
		);

		$this->add_responsive_control(
			'top_tabs_frame_border_radius',
			[
				'label'      => esc_html__( 'Tabs Frame Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-form-tabs-enable' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'top_tabs_inner_padding',
			[
				'label'      => esc_html__( 'Tab Inner Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-mod-tabs-list .rhea-mod-tab-name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'space_between_tabs',
			[
				'label'     => esc_html__( 'Tabs Horizontal Space (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-search-top-tabs-box' => 'margin-left: -{{SIZE}}{{UNIT}};margin-right: -{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rhea-mod-tab'             => 'margin-left: {{SIZE}}{{UNIT}};margin-right: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'vertical_space_between_tabs',
			[
				'label'     => esc_html__( 'Tabs Vertical Space (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea-mod-tab' => 'margin-top: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'enable_underline',
			[
				'label'        => esc_html__( 'Enable Tabs Under Line', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => '',
			]
		);

		$this->add_responsive_control(
			'underline_width',
			[
				'label'     => esc_html__( 'Reduce Underline Width (from 100%)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .enable-underline .rhea-mod-tab-name:after' => 'max-width: Calc(100% - {{SIZE}}{{UNIT}});',
				],
				'condition' => [
					'enable_underline' => 'yes',
				]
			]
		);

		$this->add_responsive_control(
			'underline_position_left',
			[
				'label'     => esc_html__( 'Underline Position Left', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .enable-underline .rhea-mod-tab-name:after' => 'left: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'enable_underline' => 'yes',
				]
			]
		);

		$this->add_responsive_control(
			'underline_position_buttom',
			[
				'label'     => esc_html__( 'Underline Position Bottom', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .enable-underline .rhea-mod-tab-name:after' => 'bottom: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'enable_underline' => 'yes',
				]
			]
		);

		$this->add_control(
			'underline_hover_color',
			[
				'label'     => esc_html__( 'Underline Hover/Checked Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .enable-underline input[type=radio]:hover~*:after'   => 'background: {{VALUE}}',
					'{{WRAPPER}} .enable-underline input[type=radio]:checked~*:after' => 'background: {{VALUE}}',
				],
				'condition' => [
					'enable_underline' => 'yes',
				]
			]
		);


		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'tabs_typography',
				'label'    => esc_html__( 'Tabs Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' =>
					'{{WRAPPER}} .rhea-mod-tabs-list .rhea-mod-tab-name',
			]
		);

		$this->add_control(
			'frames_bg_color',
			[
				'label'     => esc_html__( 'Frame Background Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-form-tabs-enable' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'tabs_bg_color',
			[
				'label'     => esc_html__( 'Tabs Background Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-mod-tabs-list .rhea-mod-tab-name' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'tabs_bg_hover_color',
			[
				'label'     => esc_html__( 'Tabs Background Hover/Active Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-mod-tabs-list input[type=radio]:hover~*'   => 'background: {{VALUE}}',
					'{{WRAPPER}} .rhea-mod-tabs-list input[type=radio]:checked~*' => 'background: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'tabs_text_color',
			[
				'label'     => esc_html__( 'Tabs Text Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-mod-tabs-list .rhea-mod-tab-name' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'tabs_text_hover_color',
			[
				'label'     => esc_html__( 'Tabs Text Hover/Active Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea-mod-tabs-list input[type=radio]:hover~*'   => 'color: {{VALUE}}',
					'{{WRAPPER}} .rhea-mod-tabs-list input[type=radio]:checked~*' => 'color: {{VALUE}}',
				],
			]
		);


		$this->add_control(
			'tabs-box-border-heading',
			[
				'label' => esc_html__( 'Tabs Box Border Settings', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::HEADING,
			]
		);

		$this->add_responsive_control(
			'tabs-box-border-radius',
			[
				'label'      => esc_html__( 'Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-search-top-tabs-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'tabs_border_heading',
			[
				'label' => esc_html__( 'Tabs Border Settings', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::HEADING,
			]
		);

		$this->add_responsive_control(
			'tabs-border-radius',
			[
				'label'      => esc_html__( 'Border Radius', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea-mod-tabs-list .rhea-mod-tab-name' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);


		$this->start_controls_tabs(
			'search_tabs_border'
		);

		$this->start_controls_tab(
			'tab_styles_normal',
			[
				'label' => esc_html__( 'Normal', RHEA_TEXT_DOMAIN ),
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'tabs-border',
				'label'    => esc_html__( 'Tabs Border', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rhea-mod-tabs-list .rhea-mod-tab-name',
			]
		);

		$this->end_controls_tab();

		$this->start_controls_tab(
			'tab_styles_hover',
			[
				'label' => esc_html__( 'Hover', RHEA_TEXT_DOMAIN ),
			]
		);
		$this->add_group_control(
			\Elementor\Group_Control_Border::get_type(),
			[
				'name'     => 'tabs-border-hover',
				'label'    => esc_html__( 'Tabs Border Hover', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rhea-mod-tabs-list input[type=radio]:hover~*,{{WRAPPER}} .rhea-mod-tabs-list input[type=radio]:checked~*',
			]
		);

		$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();

		$this->start_controls_section(
			'rhea_property_location_section',
			[
				'label' => esc_html__( 'Property Locations', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'location_radius_search',
			[
				'label'        => esc_html__( 'Enable Radius Location Search (Google Maps Only)', RHEA_TEXT_DOMAIN ),
				'description'  => esc_html__( 'To enable Radius Search, go to "Dashboard > Easy Real Estate > Maps" tab.', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => '',
			]
		);

		$this->add_control(
			'rhea_select_locations',
			[
				'label'       => esc_html__( 'Number of Location Select Boxes', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'In case of 1 location box, all locations will be listed in that select box. In case of 2 or more, Each select box will list parent locations of a level that matches its number and all the remaining children locations will be listed in last select box.', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SELECT2,
				'default'     => '1',
				'label_block' => true,
				'options'     => array(
					'1' => esc_html__( '1', RHEA_TEXT_DOMAIN ),
					'2' => esc_html__( '2', RHEA_TEXT_DOMAIN ),
					'3' => esc_html__( '3', RHEA_TEXT_DOMAIN ),
					'4' => esc_html__( '4', RHEA_TEXT_DOMAIN ),
				),
				'condition'   => [
					'location_radius_search' => '',
				]
			]
		);

		$this->add_control(
			'rhea_location_title_1',
			[
				'label'      => esc_html__( 'Main Location', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::TEXT,
				'default'    => esc_html__( 'Main Location', RHEA_TEXT_DOMAIN ),
				'conditions' => [
					'relation' => 'or',
					'terms'    => [
						[
							'name'     => 'rhea_select_locations',
							'operator' => '==',
							'value'    => '1'
						],
						[
							'name'     => 'rhea_select_locations',
							'operator' => '==',
							'value'    => '2'
						],
						[
							'name'     => 'rhea_select_locations',
							'operator' => '==',
							'value'    => '3'
						],
						[
							'name'     => 'rhea_select_locations',
							'operator' => '==',
							'value'    => '4'
						],
					]
				],
			]
		);
		$this->add_control(
			'rhea_location_ph_1',
			[
				'label'      => esc_html__( 'Main Location Placeholder', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::TEXT,
				'default'    => esc_html__( 'All Main Locations', RHEA_TEXT_DOMAIN ),
				'conditions' => [
					'relation' => 'or',
					'terms'    => [
						[
							'name'     => 'rhea_select_locations',
							'operator' => '==',
							'value'    => '1'
						],
						[
							'name'     => 'rhea_select_locations',
							'operator' => '==',
							'value'    => '2'
						],
						[
							'name'     => 'rhea_select_locations',
							'operator' => '==',
							'value'    => '3'
						],
						[
							'name'     => 'rhea_select_locations',
							'operator' => '==',
							'value'    => '4'
						],
					]
				],
			]
		);

		$this->add_control(
			'location_count_placeholder',
			[
				'label'       => esc_html__( 'Location Count Placeholder', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Placeholder text when more than 2 values are being selected', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => esc_html__( 'Locations Selected', RHEA_TEXT_DOMAIN ),
				'condition'   => [
					'rhea_select_locations' => '1',
				]
			]
		);


		$this->add_control(
			'rhea_location_title_2',
			[
				'label'      => esc_html__( 'Child Location ', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::TEXT,
				'default'    => esc_html__( 'Child Location', RHEA_TEXT_DOMAIN ),
				'conditions' => [
					'relation' => 'or',
					'terms'    => [
						[
							'name'     => 'rhea_select_locations',
							'operator' => '==',
							'value'    => '2'
						],
						[
							'name'     => 'rhea_select_locations',
							'operator' => '==',
							'value'    => '3'
						],
						[
							'name'     => 'rhea_select_locations',
							'operator' => '==',
							'value'    => '4'
						],
					]
				],
			]
		);

		$this->add_control(
			'rhea_location_ph_2',
			[
				'label'      => esc_html__( 'Main Child Placeholder', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::TEXT,
				'default'    => esc_html__( 'All Child Locations', RHEA_TEXT_DOMAIN ),
				'conditions' => [
					'relation' => 'or',
					'terms'    => [
						[
							'name'     => 'rhea_select_locations',
							'operator' => '==',
							'value'    => '2'
						],
						[
							'name'     => 'rhea_select_locations',
							'operator' => '==',
							'value'    => '3'
						],
						[
							'name'     => 'rhea_select_locations',
							'operator' => '==',
							'value'    => '4'
						],
					]
				],
			]
		);

		$this->add_control(
			'rhea_location_title_3',
			[
				'label'      => esc_html__( 'Grand Child Location', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::TEXT,
				'default'    => esc_html__( 'Grand Child Location', RHEA_TEXT_DOMAIN ),
				'conditions' => [
					'relation' => 'or',
					'terms'    => [
						[
							'name'     => 'rhea_select_locations',
							'operator' => '==',
							'value'    => '3'
						],
						[
							'name'     => 'rhea_select_locations',
							'operator' => '==',
							'value'    => '4'
						],
					]
				],
			]
		);
		$this->add_control(
			'rhea_location_ph_3',
			[
				'label'      => esc_html__( 'Grand Child Placeholder', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::TEXT,
				'default'    => esc_html__( 'All Grand Child Locations', RHEA_TEXT_DOMAIN ),
				'conditions' => [
					'relation' => 'or',
					'terms'    => [
						[
							'name'     => 'rhea_select_locations',
							'operator' => '==',
							'value'    => '3'
						],
						[
							'name'     => 'rhea_select_locations',
							'operator' => '==',
							'value'    => '4'
						],
					]
				],
			]
		);
		$this->add_control(
			'rhea_location_title_4',
			[
				'label'      => esc_html__( 'Great Grand Child Location', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::TEXT,
				'default'    => esc_html__( 'Great Grand Child Location', RHEA_TEXT_DOMAIN ),
				'conditions' => [
					'relation' => 'or',
					'terms'    => [
						[
							'name'     => 'rhea_select_locations',
							'operator' => '==',
							'value'    => '4'
						],
					]
				],
			]
		);

		$this->add_control(
			'rhea_location_ph_4',
			[
				'label'      => esc_html__( 'Great Grand Child Placeholder', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::TEXT,
				'default'    => esc_html__( 'All Great Grand Child Locations', RHEA_TEXT_DOMAIN ),
				'conditions' => [
					'relation' => 'or',
					'terms'    => [
						[
							'name'     => 'rhea_select_locations',
							'operator' => '==',
							'value'    => '4'
						],
					]
				],
			]
		);

		$this->add_control(
			'set_multiple_location',
			[
				'label'        => esc_html__( 'Enable Multi Select ?', RHEA_TEXT_DOMAIN ),
				'description'  => esc_html__( 'This will enable multi select if Number of Location Select Boxes is equal to 1.', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
				'conditions'   => [
					'relation' => 'and',
					'terms'    => [
						[
							'name'     => 'rhea_select_locations',
							'operator' => '==',
							'value'    => '1'
						],
						[
							'name'     => 'location_radius_search',
							'operator' => '==',
							'value'    => ''
						],
					]
				],
			]
		);

		$this->add_control(
			'set_ajax_location',
			[
				'label'        => esc_html__( 'Enable Ajax Based Locations ?', RHEA_TEXT_DOMAIN ),
				'description'  => esc_html__( 'This will enable ajax based locations if Number of Location Select Boxes is equal to 1.', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
				'conditions'   => [
					'relation' => 'and',
					'terms'    => [
						[
							'name'     => 'rhea_select_locations',
							'operator' => '==',
							'value'    => '1'
						],
						[
							'name'     => 'location_radius_search',
							'operator' => '==',
							'value'    => ''
						],
					]
				],
			]
		);

		$this->add_control(
			'rhea_ajax_input_placeholder',
			[
				'label'     => esc_html__( 'Live Search Placeholder', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => esc_html__( 'Enter location name', RHEA_TEXT_DOMAIN ),
				'condition' => [
					'set_ajax_location' => 'yes',
				],
			]
		);

		$this->add_control(
			'rhea_no_result_matched',
			[
				'label'     => esc_html__( 'No Result Text', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => esc_html__( 'No Location Matched', RHEA_TEXT_DOMAIN ),
				'condition' => [
					'set_ajax_location' => 'yes',
				],
			]
		);

		$this->add_control(
			'hide_empty_location',
			[
				'label'        => esc_html__( 'Hide Empty Locations ?', RHEA_TEXT_DOMAIN ),
				'description'  => esc_html__( 'Optimize Locations by hiding the ones with zero property.', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
				'condition'    => [
					'location_radius_search' => '',
				]
			]
		);
		$this->add_control(
			'sort_location_alphabetically',
			[
				'label'        => esc_html__( 'Sort Locations Alphabetically ?', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
				'condition'    => [
					'set_ajax_location'     => 'yes',
					'rhea_select_locations' => '1',
				],
			]
		);

		$this->add_responsive_control(
			'property_locations_field_size',
			[
				'label'       => esc_html__( 'Field Size (%)', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Width can be set globally for Collapsed/Advance fields from Style > Collapsed Fields Width', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SLIDER,
				'size_units'  => [ '%', 'px' ],
				'range'       => [
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors'   => [
					'{{WRAPPER}} .rhea_prop_locations_field' => 'width: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->SF_fields_icons( 'enable_location_icon', 'location_icon', 'rhea_prop_locations_field' );

		$this->field_border( 'location_field_border', 'rhea_prop_locations_field' );

		$this->end_controls_section();

		$this->SF_radius_fields();

		if ( $this->is_rvr_enabled ) {
			$this->start_controls_section(
				'rhea_property_check_in_out_section',
				[
					'label' => esc_html__( 'Check In/Out', RHEA_TEXT_DOMAIN ),
					'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
				]
			);

			$this->add_control(
				'show_single_checkin_checkout_field',
				[
					'label'        => esc_html__( 'Show Single Field', RHEA_TEXT_DOMAIN ),
					'type'         => \Elementor\Controls_Manager::SWITCHER,
					'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
					'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
					'return_value' => 'yes',
					'default'      => 'no',
				]
			);

			$this->add_control(
				'check_in_label',
				[
					'label'   => esc_html__( 'Check In Label', RHEA_TEXT_DOMAIN ),
					'type'    => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Check In', RHEA_TEXT_DOMAIN ),
				]
			);

			$this->add_control(
				'check_in_placeholder',
				[
					'label'   => esc_html__( 'Check In Placeholder', RHEA_TEXT_DOMAIN ),
					'type'    => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Check In', RHEA_TEXT_DOMAIN ),
				]
			);

			$this->add_control(
				'check_out_label',
				[
					'label'      => esc_html__( 'Check Out Label', RHEA_TEXT_DOMAIN ),
					'type'       => \Elementor\Controls_Manager::TEXT,
					'default'    => esc_html__( 'Check Out', RHEA_TEXT_DOMAIN ),
					'conditions' => [
						'terms' => [
							[
								'name'     => 'show_single_checkin_checkout_field',
								'operator' => '!==',
								'value'    => 'yes'
							],
						]
					],
				]
			);

			$this->add_control(
				'check_out_placeholder',
				[
					'label'      => esc_html__( 'Check Out Placeholder', RHEA_TEXT_DOMAIN ),
					'type'       => \Elementor\Controls_Manager::TEXT,
					'default'    => esc_html__( 'Check Out', RHEA_TEXT_DOMAIN ),
					'conditions' => [
						'terms' => [
							[
								'name'     => 'show_single_checkin_checkout_field',
								'operator' => '!==',
								'value'    => 'yes'
							],
						]
					],
				]
			);

			$this->add_responsive_control(
				'check_in_field_size',
				[
					'label'       => esc_html__( 'Check In Field Size (%)', RHEA_TEXT_DOMAIN ),
					'description' => esc_html__( 'Size will be implemented on both fields. Width can be set globally for Collapsed/Advance fields from "Style > Collapsed Fields Width"', RHEA_TEXT_DOMAIN ),
					'type'        => \Elementor\Controls_Manager::SLIDER,
					'size_units'  => [ '%', 'px' ],
					'range'       => [
						'%'  => [
							'min' => 0,
							'max' => 100,
						],
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
					],
					'selectors'   => [
						'{{WRAPPER}} .rhea_mod_text_field.rvr_check_in' => 'width: {{SIZE}}{{UNIT}} !important;'
					],
				]
			);

			$this->add_responsive_control(
				'check_out_field_size',
				[
					'label'       => esc_html__( 'Check Out Field Size (%)', RHEA_TEXT_DOMAIN ),
					'description' => esc_html__( 'Size will be implemented on both fields. Width can be set globally for Collapsed/Advance fields from "Style > Collapsed Fields Width"', RHEA_TEXT_DOMAIN ),
					'type'        => \Elementor\Controls_Manager::SLIDER,
					'size_units'  => [ '%', 'px' ],
					'range'       => [
						'%'  => [
							'min' => 0,
							'max' => 100,
						],
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
					],
					'selectors'   => [
						'{{WRAPPER}} .rhea_mod_text_field.rvr_check_out' => 'width: {{SIZE}}{{UNIT}} !important;'
					],
					'conditions'  => [
						'terms' => [
							[
								'name'     => 'show_single_checkin_checkout_field',
								'operator' => '!==',
								'value'    => 'yes'
							],
						]
					],
				]
			);

			$this->add_responsive_control(
				'calender-position',
				[
					'label'      => esc_html__( 'Calender Horizontal Position', RHEA_TEXT_DOMAIN ),
					'type'       => \Elementor\Controls_Manager::SLIDER,
					'size_units' => [ '%', 'px' ],
					'range'      => [
						'%'  => [
							'min' => -100,
							'max' => 100,
						],
						'px' => [
							'min' => -1000,
							'max' => 1000,
						],
					],
					'selectors'  => [
						'{{WRAPPER}} .daterangepicker' => 'margin-left: {{SIZE}}{{UNIT}} !important;'
					],
				]
			);

			$this->SF_fields_icons( 'enable_check_in_out_icon', 'check_in_out_icon', 'rvr_check_in' );

			$this->field_border( 'check_in_out_border', 'rvr_check_in' );

			$this->end_controls_section();

			$this->start_controls_section(
				'rhea_property_guests_section',
				[
					'label' => esc_html__( 'Guests', RHEA_TEXT_DOMAIN ),
					'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
				]
			);

			$this->add_control(
				'guests_field_type',
				[
					'label'       => esc_html__( 'Type Of Guests Fields', RHEA_TEXT_DOMAIN ),
					'type'        => \Elementor\Controls_Manager::SELECT2,
					'default'     => 'default',
					'label_block' => true,
					'options'     => array(
						'default'     => esc_html__( 'Default', RHEA_TEXT_DOMAIN ),
						'guest-types' => esc_html__( 'Guests Categories', RHEA_TEXT_DOMAIN ),
					),
				]
			);

			$this->add_control(
				'guests_label',
				[
					'label'   => esc_html__( 'Guests Label', RHEA_TEXT_DOMAIN ),
					'type'    => \Elementor\Controls_Manager::TEXT,
					'default' => esc_html__( 'Guests', RHEA_TEXT_DOMAIN ),
				]
			);

			$this->add_control(
				'max_guests',
				[
					'label'   => esc_html__( 'Max Guests', RHEA_TEXT_DOMAIN ),
					'type'    => \Elementor\Controls_Manager::NUMBER,
					'min'     => 1,
					'max'     => 100,
					'step'    => 1,
					'default' => 10,
				]
			);

			$this->add_control(
				'guests_placeholder',
				[
					'label'     => esc_html__( 'Guests Placeholder', RHEA_TEXT_DOMAIN ),
					'type'      => \Elementor\Controls_Manager::TEXT,
					'default'   => esc_html__( 'Guests', RHEA_TEXT_DOMAIN ),
					'condition' => [
						'guests_field_type' => 'default',
					],
				]
			);

			$this->add_control(
				'adults_label',
				[
					'label'     => esc_html__( 'Adults Label', RHEA_TEXT_DOMAIN ),
					'type'      => \Elementor\Controls_Manager::TEXT,
					'default'   => esc_html__( 'Adults', RHEA_TEXT_DOMAIN ),
					'condition' => [
						'guests_field_type' => 'guest-types',
					],
				]
			);

			$this->add_control(
				'adults_age_limit',
				[
					'label'     => esc_html__( 'Adults Age Limit', RHEA_TEXT_DOMAIN ),
					'type'      => \Elementor\Controls_Manager::TEXT,
					'default'   => esc_html__( '(12+ yrs)', RHEA_TEXT_DOMAIN ),
					'condition' => [
						'guests_field_type' => 'guest-types',
					],
				]
			);

			$this->add_control(
				'show_children_field',
				[
					'label'        => esc_html__( 'Show Children Field', RHEA_TEXT_DOMAIN ),
					'type'         => \Elementor\Controls_Manager::SWITCHER,
					'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
					'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
					'return_value' => 'yes',
					'default'      => 'yes',
				]
			);

			$this->add_control(
				'children_label',
				[
					'label'     => esc_html__( 'Children Label', RHEA_TEXT_DOMAIN ),
					'type'      => \Elementor\Controls_Manager::TEXT,
					'default'   => esc_html__( 'Children', RHEA_TEXT_DOMAIN ),
					'conditions'   => [
						'relation' => 'and',
						'terms'    => [
							[
								'name'     => 'guests_field_type',
								'operator' => '==',
								'value'    => 'guest-types'
							],
							[
								'name'     => 'show_children_field',
								'operator' => '==',
								'value'    => 'yes'
							],
						]
					],
				]
			);

			$this->add_control(
				'children_age_limit',
				[
					'label'     => esc_html__( 'Children Age Limit', RHEA_TEXT_DOMAIN ),
					'type'      => \Elementor\Controls_Manager::TEXT,
					'default'   => esc_html__( '( 2-12 yrs)', RHEA_TEXT_DOMAIN ),
					'conditions'   => [
						'relation' => 'and',
						'terms'    => [
							[
								'name'     => 'guests_field_type',
								'operator' => '==',
								'value'    => 'guest-types'
							],
							[
								'name'     => 'show_children_field',
								'operator' => '==',
								'value'    => 'yes'
							],
						]
					],
				]
			);

			$this->add_control(
				'show_infants_field',
				[
					'label'        => esc_html__( 'Show Infants Field', RHEA_TEXT_DOMAIN ),
					'type'         => \Elementor\Controls_Manager::SWITCHER,
					'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
					'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
					'return_value' => 'yes',
					'default'      => 'yes',
				]
			);

			$this->add_control(
				'infants_label',
				[
					'label'     => esc_html__( 'Infants Label', RHEA_TEXT_DOMAIN ),
					'type'      => \Elementor\Controls_Manager::TEXT,
					'default'   => esc_html__( 'Infants', RHEA_TEXT_DOMAIN ),
					'conditions'   => [
						'relation' => 'and',
						'terms'    => [
							[
								'name'     => 'guests_field_type',
								'operator' => '==',
								'value'    => 'guest-types'
							],
							[
								'name'     => 'show_infants_field',
								'operator' => '==',
								'value'    => 'yes'
							],
						]
					],
				]
			);

			$this->add_control(
				'infants_age_limit',
				[
					'label'     => esc_html__( 'Infants Age Limit', RHEA_TEXT_DOMAIN ),
					'type'      => \Elementor\Controls_Manager::TEXT,
					'default'   => esc_html__( '( < 2 yrs)', RHEA_TEXT_DOMAIN ),
					'conditions'   => [
						'relation' => 'and',
						'terms'    => [
							[
								'name'     => 'guests_field_type',
								'operator' => '==',
								'value'    => 'guest-types'
							],
							[
								'name'     => 'show_infants_field',
								'operator' => '==',
								'value'    => 'yes'
							],
						]
					],
				]
			);

			$this->add_control(
				'show_bedrooms_field',
				[
					'label'        => esc_html__( 'Show Bedrooms Field', RHEA_TEXT_DOMAIN ),
					'type'         => \Elementor\Controls_Manager::SWITCHER,
					'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
					'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
					'return_value' => 'yes',
					'default'      => 'yes',
				]
			);
			$this->add_control(
				'bedrooms_label',
				[
					'label'     => esc_html__( 'Bedrooms Label', RHEA_TEXT_DOMAIN ),
					'type'      => \Elementor\Controls_Manager::TEXT,
					'default'   => esc_html__( 'Bedrooms', RHEA_TEXT_DOMAIN ),
					'conditions'   => [
						'relation' => 'and',
						'terms'    => [
							[
								'name'     => 'guests_field_type',
								'operator' => '==',
								'value'    => 'guest-types'
							],
							[
								'name'     => 'show_bedrooms_field',
								'operator' => '==',
								'value'    => 'yes'
							],
						]
					],
				]
			);

			$this->add_control(
				'bedroom_sub_label',
				[
					'label'     => esc_html__( 'Bedrooms Sub Label', RHEA_TEXT_DOMAIN ),
					'type'      => \Elementor\Controls_Manager::TEXT,
					'default'   => esc_html__( 'Min Beds', RHEA_TEXT_DOMAIN ),
					'conditions'   => [
						'relation' => 'and',
						'terms'    => [
							[
								'name'     => 'guests_field_type',
								'operator' => '==',
								'value'    => 'guest-types'
							],
							[
								'name'     => 'show_bedrooms_field',
								'operator' => '==',
								'value'    => 'yes'
							],
						]
					],
				]
			);

			$this->add_responsive_control(
				'guests_field_size',
				[
					'label'       => esc_html__( 'Field Size (%)', RHEA_TEXT_DOMAIN ),
					'description' => esc_html__( 'Width can be set globally for Collapsed/Advance fields from "Style > Collapsed Fields Width"', RHEA_TEXT_DOMAIN ),
					'type'        => \Elementor\Controls_Manager::SLIDER,
					'size_units'  => [ '%', 'px' ],
					'range'       => [
						'%'  => [
							'min' => 0,
							'max' => 100,
						],
						'px' => [
							'min' => 0,
							'max' => 1000,
						],
					],
					'selectors'   => [
						'{{WRAPPER}} .rhea_rvr_guests_field' => 'width: {{SIZE}}{{UNIT}} !important;',
					],
				]
			);

			$this->add_responsive_control(
				'rhea_guest_box_padding',
				[
					'label'      => esc_html__( 'Field inner Padding', RHEA_TEXT_DOMAIN ),
					'type'       => \Elementor\Controls_Manager::DIMENSIONS,
					'size_units' => [ 'px', '%', 'em' ],
					'selectors'  => [
						'{{WRAPPER}} .rhea-guests-field-dropdown-box .rhea-guests-field-dropdown' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
					'condition'  => [
						'guests_field_type' => 'guest-types',
					],
				]
			);

			$this->SF_fields_icons( 'enable_guests_icon', 'guests_icon', 'rhea_rvr_guests_field' );

			$this->field_border( 'guests_field_border', 'rhea_rvr_guests_field' );

			$this->end_controls_section();
		}

		$this->start_controls_section(
			'rhea_property_status_section',
			[
				'label' => esc_html__( 'Property Status', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'property_status_label',
			[
				'label'   => esc_html__( 'Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Property Status', RHEA_TEXT_DOMAIN ),
			]
		);


		$this->add_control(
			'property_status_placeholder',
			[
				'label'   => esc_html__( 'Placeholder', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'All Status', RHEA_TEXT_DOMAIN ),
			]
		);

		$rhea_all_statuses = get_terms( array( 'taxonomy' => 'property-status', 'hide_empty' => false, ) );
		$status_options    = array();
		$status_default    = array();
		if ( ! empty( $rhea_all_statuses ) && ! is_wp_error( $rhea_all_statuses ) ) {
			foreach ( $rhea_all_statuses as $status ) {
				$status_options[ $status->term_id ] = $status->name;
				$status_default[ $status->slug ]    = $status->name;
			}
		}

		$rhea_all_types = get_terms( array( 'taxonomy' => 'property-type', 'hide_empty' => false, ) );
		$types_default  = array();
		$exclude_types  = array();
		if ( ! empty( $rhea_all_types ) && ! is_wp_error( $rhea_all_types ) ) {
			foreach ( $rhea_all_types as $types ) {
				$types_default[ $types->slug ]    = $types->name;
				$exclude_types[ $types->term_id ] = $types->name;

			}
		}


		$this->add_control(
			'status_count_placeholder',
			[
				'label'       => esc_html__( 'Count Placeholder', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Placeholder text when more than 2 values are being selected', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => esc_html__( 'Status Selected', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'show_status_in_tabs',
			[
				'label'        => esc_html__( 'Show Property Status In Tabs', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$this->add_control(
			'show_all_tab_status',
			[
				'label'        => esc_html__( 'Show All Types Tabs', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => [
					'show_status_in_tabs' => 'yes',
				],
			]
		);


		$this->add_control(
			'default_status_select',
			[
				'label'       => esc_html__( 'Default Selected Status', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SELECT2,
				'multiple'    => false,
				'label_block' => true,
				'options'     => $status_default,
			]
		);

		$this->add_control(
			'status_in_tabs',
			[
				'label'       => esc_html__( 'Select Status To Show In Tabs', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SELECT2,
				'multiple'    => true,
				'label_block' => true,
				'options'     => $status_default,
				'condition'   => [
					'show_status_in_tabs' => 'yes',
				],
			]
		);

		$this->add_control(
			'rhea_select_exclude_status',
			[
				'label'       => esc_html__( 'Exclude Status', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SELECT2,
				'multiple'    => true,
				'label_block' => true,
				'options'     => $status_options,
				'condition'   => [
					'show_status_in_tabs' => '',
				],
			]
		);

		$this->add_responsive_control(
			'property_status_field_size',
			[
				'label'       => esc_html__( 'Field Size (%)', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Width can be set globally for Collapsed/Advance fields from Style > Collapsed Fields Width', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SLIDER,
				'size_units'  => [ '%', 'px' ],
				'range'       => [
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors'   => [
					'{{WRAPPER}} .rhea_status_field' => 'width: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->SF_fields_icons( 'enable_status_icon', 'status_icon', 'rhea_status_field' );
		$this->field_border( 'status_field_border', 'rhea_status_field' );
		$this->end_controls_section();
		$this->start_controls_section(
			'rhea_property_type_section',
			[
				'label' => esc_html__( 'Property Type', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'property_types_label',
			[
				'label'   => esc_html__( 'Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Property Types', RHEA_TEXT_DOMAIN ),
			]
		);


		$this->add_control(
			'property_types_placeholder',
			[
				'label'   => esc_html__( 'Placeholder / All Tab', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'All Types', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'types_count_placeholder',
			[
				'label'       => esc_html__( 'Count Placeholder', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Placeholder text when more than 2 values are being selected', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => esc_html__( 'Types Selected', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'show_types_in_tabs',
			[
				'label'        => esc_html__( 'Show Property Types In Tabs', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$this->add_control(
			'show_all_tab',
			[
				'label'        => esc_html__( 'Show All Types Tabs', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => [
					'show_types_in_tabs' => 'yes',
				],
			]
		);


		$this->add_control(
			'types_in_tabs',
			[
				'label'       => esc_html__( 'Select Types To Show In Tabs', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SELECT2,
				'multiple'    => true,
				'label_block' => true,
				'options'     => $types_default,
				'condition'   => [
					'show_types_in_tabs' => 'yes',
				],
			]
		);

		$this->add_control(
			'default_types_select',
			[
				'label'       => esc_html__( 'Default Selected Types', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SELECT2,
				'multiple'    => false,
				'label_block' => true,
				'options'     => $types_default,
			]
		);

		$this->add_control(
			'select_excluded_types',
			[
				'label'       => esc_html__( 'Exclude Selected Types', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SELECT2,
				'multiple'    => true,
				'label_block' => true,
				'options'     => $exclude_types,
				'condition'   => [
					'show_types_in_tabs' => '',
				],
			]
		);


		$this->add_control(
			'show_types_select_all',
			[
				'label'        => esc_html__( 'Show Select/Deselect All?', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'set_multiple_types',
			[
				'label'        => esc_html__( 'Enable Multi Select ?', RHEA_TEXT_DOMAIN ),
				'description'  => esc_html__( 'This will enable multi select.', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$this->add_responsive_control(
			'property_types_field_size',
			[
				'label'       => esc_html__( 'Field Size (%)', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Width can be set globally for Collapsed/Advance fields from Style > Collapsed Fields Width', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SLIDER,
				'size_units'  => [ '%', 'px' ],
				'range'       => [
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors'   => [
					'{{WRAPPER}} .rhea_types_field' => 'width: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->SF_fields_icons( 'enable_type_icon', 'type_icon', 'rhea_types_field' );
		$this->field_border( 'type_field_border', 'rhea_types_field' );
		$this->end_controls_section();

		$this->start_controls_section(
			'rhea_property_min_beds_section',
			[
				'label' => esc_html__( 'Bedrooms', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


		$this->add_control(
			'min_bed_label',
			[
				'label'   => esc_html__( 'Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Bedrooms', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'min_bed_placeholder',
			[
				'label'   => esc_html__( 'Placeholder', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'All Beds', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'min_bed_drop_down_value',
			[
				'label'       => esc_html__( 'Values In Drop Down', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Only provide comma separated numbers. Do not add decimal points, dashes and spaces.', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'default'     => esc_html__( '1,2,3,4,5', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_responsive_control(
			'min_bed_field_size',
			[
				'label'       => esc_html__( 'Field Size (%)', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Width can be set globally for Collapsed/Advance fields from Style > Collapsed Fields Width', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SLIDER,
				'size_units'  => [ '%', 'px' ],
				'range'       => [
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors'   => [
					'{{WRAPPER}} .rhea_min_beds_field' => 'width: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->SF_radio_buttons( 'bedrooms' );
		$this->SF_fields_icons( 'enable_min_beds_icon', 'min_beds_icon', 'rhea_min_beds_field' );
		$this->field_border( 'min_bed_field_border', 'rhea_min_beds_field', false );
		$this->end_controls_section();
		$this->start_controls_section(
			'rhea_property_min_baths_section',
			[
				'label' => esc_html__( 'Bathrooms', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'min_bath_label',
			[
				'label'   => esc_html__( 'Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Bathrooms', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'min_bath_placeholder',
			[
				'label'   => esc_html__( 'Placeholder', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'All Baths', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'min_bath_drop_down_value',
			[
				'label'       => esc_html__( 'Values In Drop Down', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Only provide comma separated numbers. Do not add decimal points, dashes and spaces.', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'default'     => esc_html__( '1,2,3,4,5', RHEA_TEXT_DOMAIN ),
			]
		);


		$this->add_responsive_control(
			'min_bath_field_size',
			[
				'label'       => esc_html__( 'Field Size (%)', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Width can be set globally for Collapsed/Advance fields from Style > Collapsed Fields Width', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SLIDER,
				'size_units'  => [ '%', 'px' ],
				'range'       => [
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors'   => [
					'{{WRAPPER}} .rhea_min_baths_field' => 'width: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->SF_radio_buttons( 'bathrooms' );
		$this->SF_fields_icons( 'enable_min_baths_icon', 'min_baths_icon', 'rhea_min_baths_field' );
		$this->field_border( 'min_bath_field_border', 'rhea_min_baths_field', false );
		$this->end_controls_section();

		$this->start_controls_section(
			'rhea_property_min_max_price_section',
			[
				'label' => esc_html__( 'Min Max Price', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


		$this->add_control(
			'show_select_fields',
			[
				'label'        => esc_html__( 'Switch To Select Fields', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => '',
			]
		);


		$this->add_control(
			'slider_field_label',
			[
				'label'     => esc_html__( 'Field Label', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => esc_html__( 'Price', RHEA_TEXT_DOMAIN ),
				'condition' => [
					'show_select_fields' => '',
				],
			]
		);

		$this->add_control(
			'slider_range_label',
			[
				'label'     => esc_html__( 'Price Range Label', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => esc_html__( 'Price Range', RHEA_TEXT_DOMAIN ),
				'condition' => [
					'show_select_fields' => '',
				],
			]
		);

		$this->add_control(
			'slider_range_from',
			[
				'label'     => esc_html__( 'Price From Label', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => esc_html__( 'From', RHEA_TEXT_DOMAIN ),
				'condition' => [
					'show_select_fields' => '',
				],
			]
		);
		$this->add_control(
			'slider_range_to',
			[
				'label'     => esc_html__( 'Price To Label', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => esc_html__( 'To', RHEA_TEXT_DOMAIN ),
				'condition' => [
					'show_select_fields' => '',
				],
			]
		);

		$this->add_control(
			'slider_min_price',
			[
				'label'     => esc_html__( 'Minimum Price', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'show_select_fields' => '',
				],
			]
		);

		$this->add_control(
			'slider_max_price',
			[
				'label'     => esc_html__( 'Maximum Price', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'show_select_fields' => '',
				],
			]
		);

		$this->add_responsive_control(
			'slider_price_field_size',
			[
				'label'           => esc_html__( 'Price Slider Width (%)', RHEA_TEXT_DOMAIN ),
				'type'            => \Elementor\Controls_Manager::SLIDER,
				'condition'       => [
					'show_select_fields' => '',
				],
				'size_units'      => [ '%', 'px' ],
				'range'           => [
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'desktop_default' => [
					'size' => 100,
					'unit' => '%',
				],
				'selectors'       => [
					'{{WRAPPER}} .rhea_price_slider_field' => 'width: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->add_responsive_control(
			'slider_price_field_height',
			[
				'label'     => esc_html__( 'Price Slider Height (px)', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'condition' => [
					'show_select_fields' => '',
				],
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rhea_price_slider_wrapper' => 'height: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_price_slider_padding',
			[
				'label'      => esc_html__( 'Price Slider Padding', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors'  => [
					'{{WRAPPER}} .rhea_price_slider_wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'condition'  => [
					'show_select_fields' => '',
				],
			]
		);

		$this->add_control(
			'min_price_label',
			[
				'label'     => esc_html__( 'Min Price Label', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => esc_html__( 'Min Price', RHEA_TEXT_DOMAIN ),
				'condition' => [
					'show_select_fields' => 'yes',
				],
			]
		);

		$this->add_control(
			'min_price_placeholder',
			[
				'label'     => esc_html__( 'Min Price Placeholder', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => esc_html__( 'Min Price', RHEA_TEXT_DOMAIN ),
				'condition' => [
					'show_select_fields' => 'yes',
				],
			]
		);


		$this->add_responsive_control(
			'min_price_field_size',
			[
				'label'       => esc_html__( 'Min Price Field Size (%)', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Width can be set globally for Collapsed/Advance fields from Style > Collapsed Fields Width', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SLIDER,
				'condition'   => [
					'show_select_fields' => 'yes',
				],
				'size_units'  => [ '%', 'px' ],
				'range'       => [
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors'   => [
					'{{WRAPPER}} .rhea_min_price_field' => 'width: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->add_control(
			'max_price_label',
			[
				'label'     => esc_html__( 'Max Price Label', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => esc_html__( 'Max Price', RHEA_TEXT_DOMAIN ),
				'condition' => [
					'show_select_fields' => 'yes',
				],
			]
		);

		$this->add_control(
			'max_price_placeholder',
			[
				'label'     => esc_html__( 'Max Price Placeholder', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'default'   => esc_html__( 'Max Price', RHEA_TEXT_DOMAIN ),
				'condition' => [
					'show_select_fields' => 'yes',
				],
			]
		);


		$this->add_responsive_control(
			'max_price_field_size',
			[
				'label'       => esc_html__( 'Max Price Field Size (%)', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Width can be set globally for Collapsed/Advance fields from Style > Collapsed Fields Width', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SLIDER,
				'condition'   => [
					'show_select_fields' => 'yes',
				],
				'size_units'  => [ '%', 'px' ],
				'range'       => [
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors'   => [
					'{{WRAPPER}} .rhea_max_price_field' => 'width: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->add_control(
			'min_price_drop_down_value',
			[
				'label'       => esc_html__( 'Min Price List', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Only provide comma separated numbers. Do not add decimal points, dashes, spaces and currency signs.', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'default'     => esc_html__( '1000,5000,10000,50000,100000,200000,300000,400000,500000,600000,700000,800000,900000,1000000,1500000,2000000,2500000,5000000', RHEA_TEXT_DOMAIN ),
				'condition'   => [
					'show_select_fields' => 'yes',
				],
			]
		);

		$this->add_control(
			'max_price_drop_down_value',
			[
				'label'       => esc_html__( 'Max Price List', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Only provide comma separated numbers. Do not add decimal points, dashes, spaces and currency signs.', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'default'     => esc_html__( '5000,10000,50000,100000,200000,300000,400000,500000,600000,700000,800000,900000,1000000,1500000,2000000,2500000,5000000,10000000', RHEA_TEXT_DOMAIN ),
				'condition'   => [
					'show_select_fields' => 'yes',
				],
			]
		);

		$this->add_control(
			'min_rent_price_drop_down_value',
			[
				'label'       => esc_html__( 'Min Price List For Rent', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Only provide comma separated numbers. Do not add decimal points, dashes, spaces and currency signs.', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'default'     => esc_html__( '500,1000,2000,3000,4000,5000,7500,10000,15000,20000,25000,30000,40000,50000,75000,100000', RHEA_TEXT_DOMAIN ),
				'condition'   => [
					'show_select_fields' => 'yes',
				],
			]
		);

		$this->add_control(
			'max_rent_price_drop_down_value',
			[
				'label'       => esc_html__( 'Max Price List For Rent', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Only provide comma separated numbers. Do not add decimal points, dashes, spaces and currency signs.', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'default'     => esc_html__( '1000,2000,3000,4000,5000,7500,10000,15000,20000,25000,30000,40000,50000,75000,100000,150000', RHEA_TEXT_DOMAIN ),
				'condition'   => [
					'show_select_fields' => 'yes',
				],
			]
		);

		$status_list = array();
		if ( class_exists( 'ERE_Data' ) ) {
			$status_list = ERE_Data::get_statuses_slug_name();
		};

		$this->add_control(
			'rhea_select_status_for_rent',
			[
				'label'       => esc_html__( 'Status That Represents Rent', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Visitor expects smaller values for rent prices. So provide the list of minimum and maximum rent prices below. The rent prices will be displayed based on rent status selected here.', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SELECT2,
				'default'     => 'for-rent',
				'label_block' => true,
				'options'     => $status_list,
				'condition'   => [
					'show_select_fields' => 'yes',
				],
			]
		);

		// This control is replaced with switcher control and keep the same ID to make sre existing customer has no issue
		$this->add_control(
			'price_range_on_top',
			[
				'label'       => esc_html__( 'Price Range Layout', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SELECT2,
				'default'     => 'default',
				'label_block' => true,
				'options'     => array(
					'default'  => esc_html__( 'Default', RHEA_TEXT_DOMAIN ),
					'yes'      => esc_html__( 'Layout 2', RHEA_TEXT_DOMAIN ), // yes value to support old switcher control
					'layout_3' => esc_html__( 'Layout 3', RHEA_TEXT_DOMAIN ),
				),
				'condition'   => [
					'show_select_fields' => '',
				],
			]
		);

		$this->add_responsive_control(
			'min_max_price_horizontal_position',
			[
				'label'      => esc_html__( 'Price Value Horizontal Position', RHEA_TEXT_DOMAIN ),
				'type'       => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range'      => [
					'px' => [
						'min' => -200,
						'max' => 200,
					],
				],
				'selectors'  => [
					'{{WRAPPER}} .rhea_min_slide' => 'margin-left: -{{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .rhea_max_slide' => 'margin-right: -{{SIZE}}{{UNIT}};',
				],
				'condition'  => [
					'price_range_on_top' => 'layout_3',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_price_border_colors',
			[
				'label'     => esc_html__( 'Price Slider Border Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_price_slider_wrapper' => 'border-color: {{VALUE}}',
				],
				'condition' => [
					'show_select_fields' => '',
				],
			]
		);
		$this->add_responsive_control(
			'rhea_price_range_colors',
			[
				'label'     => esc_html__( 'Price Slider Range Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_price_slider_wrapper .rhea_price_display' => 'color: {{VALUE}}',
				],
				'condition' => [
					'show_select_fields' => '',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_price_bg_color',
			[
				'label'     => esc_html__( 'Price Slider UI Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_price_slider_wrapper .ui-widget.ui-widget-content' => 'background: {{VALUE}}; border-color: {{VALUE}};',
				],
				'condition' => [
					'show_select_fields' => '',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_price_slider_color',
			[
				'label'     => esc_html__( 'Price Slider UI Range', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_price_slider_wrapper .ui-slider .ui-slider-range' => 'background: {{VALUE}};',
				],
				'condition' => [
					'show_select_fields' => '',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_price_darg_color',
			[
				'label'     => esc_html__( 'Price Slider UI Drag Button', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_price_slider_wrapper .ui-widget-content .ui-state-default' => 'background: {{VALUE}};',
				],
				'condition' => [
					'show_select_fields' => '',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_price_drag_hover_color',
			[
				'label'     => esc_html__( 'Price Slider UI Drag Button Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_price_slider_wrapper .ui-widget-content .ui-state-hover' => 'background: {{VALUE}};',
				],
				'condition' => [
					'show_select_fields' => '',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_price_drag_border_color',
			[
				'label'     => esc_html__( 'Price Slider UI Drag Button Border', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_price_slider_wrapper .ui-widget-content .ui-state-default' => 'border-color: {{VALUE}};',
				],
				'condition' => [
					'show_select_fields' => '',
				],
			]
		);

		$this->add_responsive_control(
			'rhea_price_drag_border_hover_color',
			[
				'label'     => esc_html__( 'Price Slider UI Drag Button Border Hover', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rhea_price_slider_wrapper .ui-widget-content .ui-state-hover' => 'border-color: {{VALUE}};',
				],
				'condition' => [
					'show_select_fields' => '',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'price_slider_text_typo',
				'label'    => esc_html__( 'Price Slider Text', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea_price_slider_wrapper > .rhea_price_label',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'price_slider_form_to_typo',
				'label'    => esc_html__( 'Price Slider From/To Text', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea_price_slider_wrapper > .rhea_price_range',
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'price_slider_price_typo',
				'label'    => esc_html__( 'Price Slider Min Max Range ', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rhea_price_slider_wrapper .rhea_price_display',
			]
		);

		$this->SF_fields_icons( 'enable_min_price_icon', 'min_price_icon', 'rhea_min_price_field' );
		$this->SF_fields_icons( 'enable_max_price_icon', 'max_price_icon', 'rhea_max_price_field' );
		$this->add_control(
			'slider_price_field_border_heading',
			[
				'label'     => esc_html__( 'Price Slider Border', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);
		$this->field_border( 'slider_price_field_border', 'rhea_price_slider_field ' );
		$this->add_control(
			'min_price_field_border_heading',
			[
				'label' => esc_html__( 'Min Price Border', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::HEADING,
			]
		);
		$this->field_border( 'min_price_field_border', 'rhea_min_price_field' );
		$this->add_control(
			'max_price_field_border_heading',
			[
				'label' => esc_html__( 'Max Price Border', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::HEADING,
			]
		);
		$this->field_border( 'max_price_field_border', 'rhea_max_price_field' );
		$this->end_controls_section();
		$this->start_controls_section(
			'rhea_property_garages_section',
			[
				'label' => esc_html__( 'Garages', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


		$this->add_control(
			'garages_label',
			[
				'label'   => esc_html__( 'Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Garages', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'garages_placeholder',
			[
				'label'   => esc_html__( 'Placeholder', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'All Garages', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'garages_drop_down_value',
			[
				'label'       => esc_html__( 'Values In Drop Down', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Only provide comma separated numbers. Do not add decimal points, dashes and spaces.', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::TEXTAREA,
				'default'     => esc_html__( '1,2,3,4,5', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_responsive_control(
			'garages_field_size',
			[
				'label'       => esc_html__( 'Field Size (%)', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Width can be set globally for Collapsed/Advance fields from Style > Collapsed Fields Width', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SLIDER,
				'size_units'  => [ '%', 'px' ],
				'range'       => [
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors'   => [
					'{{WRAPPER}} .rhea_garages_field' => 'width: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);
		$this->SF_radio_buttons( 'garages' );
		$this->SF_fields_icons( 'enable_garages_icon', 'garages_icon', 'rhea_garages_field' );
		$this->field_border( 'garages_field_border', 'rhea_garages_field' );
		$this->end_controls_section();

		$this->start_controls_section(
			'rhea_property_agency_section',
			[
				'label' => esc_html__( 'Agencies', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'agency_label',
			[
				'label'   => esc_html__( 'Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Agency', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'agency_placeholder',
			[
				'label'   => esc_html__( 'Placeholder', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'All Agencies', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'agency_count_placeholder',
			[
				'label'       => esc_html__( 'Count Placeholder', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Placeholder text when more than 2 values are being selected', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => esc_html__( 'Agencies Selected', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'show_select_all_for_agency',
			[
				'label'        => esc_html__( 'Show Select/Deselect All?', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'set_multiple_agencies',
			[
				'label'        => esc_html__( 'Enable Multi Select?', RHEA_TEXT_DOMAIN ),
				'description'  => esc_html__( 'This will enable multi select.', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);

		$this->add_responsive_control(
			'agency_field_size',
			[
				'label'       => esc_html__( 'Field Size (%)', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SLIDER,
				'description' => esc_html__( 'Width can be set globally for Collapsed/Advance fields from Style > Collapsed Fields Width', RHEA_TEXT_DOMAIN ),
				'size_units'  => [ '%', 'px' ],
				'range'       => [
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors'   => [
					'{{WRAPPER}} .rhea_agency_field' => 'width: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);
		$this->SF_fields_icons( 'enable_agency_icon', 'agency_icon', 'rhea_agency_field' );
		$this->field_border( 'agency_field_border', 'rhea_agency_field' );
		$this->end_controls_section();

		$this->start_controls_section(
			'rhea_property_agent_section',
			[
				'label' => esc_html__( 'Agents', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


		$this->add_control(
			'agent_label',
			[
				'label'   => esc_html__( 'Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Agent', RHEA_TEXT_DOMAIN ),
			]
		);
		$this->add_control(
			'agent_placeholder',
			[
				'label'   => esc_html__( 'Placeholder', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'All Agents', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'agent_count_placeholder',
			[
				'label'       => esc_html__( 'Count Placeholder', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Placeholder text when more than 2 values are being selected', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => esc_html__( 'Agents Selected', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'show_select_all',
			[
				'label'        => esc_html__( 'Show Select/Deselect All?', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'set_multiple_agents',
			[
				'label'        => esc_html__( 'Enable Multi Select ?', RHEA_TEXT_DOMAIN ),
				'description'  => esc_html__( 'This will enable multi select.', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);


		$this->add_responsive_control(
			'agent_field_size',
			[
				'label'       => esc_html__( 'Field Size (%)', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SLIDER,
				'description' => esc_html__( 'Width can be set globally for Collapsed/Advance fields from Style > Collapsed Fields Width', RHEA_TEXT_DOMAIN ),
				'size_units'  => [ '%', 'px' ],
				'range'       => [
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors'   => [
					'{{WRAPPER}} .rhea_agent_field' => 'width: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);
		$this->SF_fields_icons( 'enable_agent_icon', 'agent_icon', 'rhea_agent_field' );
		$this->field_border( 'agents_field_border', 'rhea_agent_field' );
		$this->end_controls_section();

		$this->start_controls_section(
			'rhea_property_min_area_section',
			[
				'label' => esc_html__( 'Min Max Area', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'min_area_label',
			[
				'label'   => esc_html__( 'Min Area Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Min Area', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'min_area_placeholder',
			[
				'label'   => esc_html__( 'Min Area Placeholder', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Min Area', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_responsive_control(
			'min_area_field_size',
			[
				'label'       => esc_html__( 'Min Area Field Size (%)', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Width can be set globally for Collapsed/Advance fields from Style > Collapsed Fields Width', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SLIDER,
				'size_units'  => [ '%', 'px' ],
				'range'       => [
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors'   => [
					'{{WRAPPER}} .rhea_min_area_field' => 'width: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->add_control(
			'max_area_label',
			[
				'label'   => esc_html__( 'Max Area Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Max Area', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'max_area_placeholder',
			[
				'label'   => esc_html__( 'Max Area Placeholder', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Max Area', RHEA_TEXT_DOMAIN ),
			]
		);


		$this->add_responsive_control(
			'max_area_field_size',
			[
				'label'       => esc_html__( 'Max Area Field Size (%)', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Width can be set globally for Collapsed/Advance fields from Style > Collapsed Fields Width', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SLIDER,
				'size_units'  => [ '%', 'px' ],
				'range'       => [
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors'   => [
					'{{WRAPPER}} .rhea_max_area_field' => 'width: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);


		$this->add_control(
			'area_units_placeholder',
			[
				'label'   => esc_html__( 'Label Units', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( '(sq ft)', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'area_units_title_attr',
			[
				'label'   => esc_html__( 'Title Attribute', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Only provide digits!', RHEA_TEXT_DOMAIN ),
			]
		);
		$this->SF_fields_icons( 'enable_min_area_icon', 'min_area_icon', 'rhea_min_area_field' );
		$this->SF_fields_icons( 'enable_max_area_icon', 'max_area_icon', 'rhea_max_area_field' );
		$this->add_control(
			'min_area_field_border_heading',
			[
				'label'     => esc_html__( 'Min Area Border', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);
		$this->field_border( 'min_area_field_border', 'rhea_min_area_field' );
		$this->add_control(
			'max_area_field_border_heading',
			[
				'label' => esc_html__( 'Max Area Border', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::HEADING,
			]
		);
		$this->field_border( 'max_area_field_border', 'rhea_max_area_field' );
		$this->end_controls_section();

		$this->start_controls_section(
			'rhea_property_min_lot_size_section',
			[
				'label' => esc_html__( 'Min Max Lot Size', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'min_lot_size_label',
			[
				'label'   => esc_html__( 'Min Lot Size Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Min Lot Size', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'min_lot_size_placeholder',
			[
				'label'   => esc_html__( 'Min Lot Size Placeholder', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Min Lot Size', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_responsive_control(
			'min_lot_size_field_size',
			[
				'label'       => esc_html__( 'Min Lot Size Field Size (%)', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Width can be set globally for Collapsed/Advance fields from Style > Collapsed Fields Width', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SLIDER,
				'size_units'  => [ '%', 'px' ],
				'range'       => [
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors'   => [
					'{{WRAPPER}} .rhea_min_lot_size_field' => 'width: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->add_control(
			'max_lot_size_label',
			[
				'label'   => esc_html__( 'Max Lot Size Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Max Lot Size', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'max_lot_size_placeholder',
			[
				'label'   => esc_html__( 'Max Lot Size Placeholder', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Max Lot Size', RHEA_TEXT_DOMAIN ),
			]
		);


		$this->add_responsive_control(
			'max_lot_size_field_size',
			[
				'label'       => esc_html__( 'Max Lot Size Field Size (%)', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Width can be set globally for Collapsed/Advance fields from Style > Collapsed Fields Width', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SLIDER,
				'size_units'  => [ '%', 'px' ],
				'range'       => [
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors'   => [
					'{{WRAPPER}} .rhea_max_lot_size_field' => 'width: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);

		$this->add_control(
			'lot_size_units_placeholder',
			[
				'label'   => esc_html__( 'Label Units', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( '(sq ft)', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'lot_size_units_title_attr',
			[
				'label'   => esc_html__( 'Title Attribute', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Only provide digits!', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->SF_fields_icons( 'enable_min_lot_icon', 'min_lot_icon', 'rhea_min_lot_size_field' );
		$this->SF_fields_icons( 'enable_max_lot_icon', 'max_lot_icon', 'rhea_max_lot_size_field' );
		$this->add_control(
			'min_lot_field_border_heading',
			[
				'label'     => esc_html__( 'Min Lot Border', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);
		$this->field_border( 'min_lot_field_border', 'rhea_min_lot_size_field' );
		$this->add_control(
			'max_lot_field_border_heading',
			[
				'label' => esc_html__( 'Max Lot Border', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::HEADING,
			]
		);
		$this->field_border( 'max_lot_field_border', 'rhea_max_lot_size_field' );
		$this->end_controls_section();

		$this->start_controls_section(
			'rhea_property_keyword_section',
			[
				'label' => esc_html__( 'Keyword', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'keyword_label',
			[
				'label'   => esc_html__( 'Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Keyword', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'keyword_placeholder',
			[
				'label'   => esc_html__( 'Placeholder', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Keyword', RHEA_TEXT_DOMAIN ),
			]
		);
		$this->add_responsive_control(
			'keyword_field_size',
			[
				'label'       => esc_html__( 'Field Size (%)', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Width can be set globally for Collapsed/Advance fields from Style > Collapsed Fields Width', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SLIDER,
				'size_units'  => [ '%', 'px' ],
				'range'       => [
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors'   => [
					'{{WRAPPER}} .rhea_keyword_field' => 'width: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);
		$this->SF_fields_icons( 'enable_keywords_icon', 'keywords_icon', 'rhea_keyword_field' );
		$this->field_border( 'keywords_field_border', 'rhea_keyword_field' );
		$this->end_controls_section();

		$this->start_controls_section(
			'rhea_property_property_id_section',
			[
				'label' => esc_html__( 'Property ID', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


		$this->add_control(
			'property_id_label',
			[
				'label'   => esc_html__( 'Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Property ID', RHEA_TEXT_DOMAIN ),
			]
		);


		$this->add_control(
			'property_id_placeholder',
			[
				'label'   => esc_html__( 'Placeholder', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Property ID', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_responsive_control(
			'property_id_field_size',
			[
				'label'       => esc_html__( 'Field Size (%)', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Width can be set globally for Collapsed/Advance fields from Style > Collapsed Fields Width', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SLIDER,
				'size_units'  => [ '%', 'px' ],
				'range'       => [
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors'   => [
					'{{WRAPPER}} .rhea_property_id_field' => 'width: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);
		$this->SF_fields_icons( 'enable_id_icon', 'id_icon', 'rhea_property_id_field' );
		$this->field_border( 'id_field_border', 'rhea_property_id_field' );
		$this->end_controls_section();

		$this->start_controls_section(
			'rhea_property_features_section',
			[
				'label' => esc_html__( 'Features', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'show_advance_features',
			[
				'label'        => esc_html__( 'Show More Features ', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'show_features_dropdown',
			[
				'label'        => esc_html__( 'Show Features In Drop Down ?', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => '',
			]
		);

		$this->add_control(
			'advance_features_text',
			[
				'label'   => esc_html__( 'Advance Features Text', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Looking for certain features', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'features_dropdown_options',
			[
				'label'     => esc_html__( 'Dropdown Fields Options', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

		$this->add_control(
			'features_label',
			[
				'label'   => esc_html__( 'Label', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Features', RHEA_TEXT_DOMAIN ),
			]
		);
		$this->add_control(
			'features_placeholder',
			[
				'label'   => esc_html__( 'Placeholder', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'All features', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'features_count_placeholder',
			[
				'label'       => esc_html__( 'Count Placeholder', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Placeholder text when more than 2 values are being selected', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => esc_html__( 'Features Selected', RHEA_TEXT_DOMAIN ),
			]
		);

		$this->add_control(
			'show_select_all_features',
			[
				'label'        => esc_html__( 'Show Select/Deselect All?', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'set_multiple_features',
			[
				'label'        => esc_html__( 'Enable Multi Select?', RHEA_TEXT_DOMAIN ),
				'description'  => esc_html__( 'This will enable multi select.', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
			]
		);


		$this->add_responsive_control(
			'features_field_size',
			[
				'label'       => esc_html__( 'Field Size (%)', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SLIDER,
				'description' => esc_html__( 'Width can be set globally for Collapsed/Advance fields from Style > Collapsed Fields Width', RHEA_TEXT_DOMAIN ),
				'size_units'  => [ '%', 'px' ],
				'range'       => [
					'%'  => [
						'min' => 0,
						'max' => 100,
					],
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors'   => [
					'{{WRAPPER}} .rhea_features_field' => 'width: {{SIZE}}{{UNIT}} !important;',
				],
			]
		);
		$this->SF_fields_icons( 'enable_features_icon', 'features_icon', 'rhea_features_field' );
		$this->field_border( 'features_field_border', 'rhea_features_field' );
		$this->end_controls_section();

		$this->start_controls_section(
			'rhea_property_additional_fields',
			[
				'label' => esc_html__( 'Additional Fields', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'rhea-important-note-control',
			[
				'label' => esc_html__( 'Note: You can add additional fields from Admin > Easy Real Estate > New Fields Builder ', RHEA_TEXT_DOMAIN ),
				'type'  => 'rhea-important-note',
			]
		);

		$this->add_control(
			'rhea_select_addition_placeholder',
			[
				'label'       => esc_html__( 'Select to display in placeholder', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'This is the first default item in select drop down list.', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::SELECT2,
				'default'     => 'name',
				'label_block' => true,
				'options'     => array(
					'name' => esc_html__( 'Field Name', RHEA_TEXT_DOMAIN ),
					'any'  => esc_html__( 'Any Text', RHEA_TEXT_DOMAIN ),
				),
			]
		);


		$this->add_control(
			'additional_field_any_text',
			[
				'label'       => esc_html__( 'Any Text PlaceHolder', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Placeholder will appear if labels are enabled from Basic Settings > Show Labels ', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'default'     => esc_html__( 'Any', RHEA_TEXT_DOMAIN ),
			]
		);


		$this->add_control(
			'prefix_placeholder',
			[
				'label'       => esc_html__( 'Placeholder Prefix', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Prefix for Select fields', RHEA_TEXT_DOMAIN ),
				'default'     => esc_html__( 'All', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'condition'   => [
					'rhea_select_addition_placeholder' => 'name',
				],
			]
		);
		$this->add_control(
			'postfix_placeholder',
			[
				'label'       => esc_html__( 'Placeholder Postfix', RHEA_TEXT_DOMAIN ),
				'description' => esc_html__( 'Postfix for Select fields', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'condition'   => [
					'rhea_select_addition_placeholder' => 'name',
				],
			]
		);

		$this->end_controls_section();
	}

	public function query_parameter_locations() {
		$parameter_locations = array();

		if ( function_exists( 'inspiry_get_location_select_names' ) ) {
			$location_names = inspiry_get_location_select_names();
			if ( 0 < count( $location_names ) ) {
				foreach ( $location_names as $location ) {
					if ( isset( $_GET[ $location ] ) ) {
						$parameter_locations[ $location ] = $_GET[ $location ];
					}
				}
			}
		}

		return $parameter_locations;
	}

	protected function render() {
		// ERE_Data class is needed for operations below
		if ( ! class_exists( 'ERE_Data' ) ) {
			return;
		}

		global $settings, $widget_name, $the_widget_id, $search_fields_to_display;

		$widget_name         = $this->get_name();
		$settings            = $this->get_settings_for_display();
		$currency_sign_space = get_option( 'ere_currency_sign_space', 'none' );

		if ( isset( $settings['rhea_search_select_sort'] ) && ! empty( $settings['rhea_search_select_sort'] ) ) {
			$search_fields_to_display = $settings['rhea_search_select_sort'];

			if ( is_string( $search_fields_to_display ) ) {
				$search_fields_to_display = explode( ',', $search_fields_to_display );
			}
		}

		$the_widget_id        = $this->get_id();
		$rhea_top_field_count = $settings['rhea_top_field_count'];


		if ( ! \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
			$visible_on_load = ' rh-hide-before-load ';
		} else {
			$visible_on_load = '';
		}

		?>
        <div class="rhea_search_form_wrapper rhea-dropdown-style-<?php echo esc_attr( $settings['dropdown-icon-style'] ) . esc_attr( $visible_on_load ) . ' rhea-radius-position-' . ( isset( $settings['radius-slider-position'] ) ? esc_attr( $settings['radius-slider-position'] ) : '' ) ?>" id="rhea-<?php echo esc_attr( $the_widget_id ); ?>">
            <form class="rhea_search_form advance-search-form" action="<?php echo esc_url( rhea_get_search_page_url( $settings['rhea_select_search_template'] ) ); ?>" method="get">
				<?php
				$tabs_enable_class   = '';
				$show_status_in_tabs = $settings['show_status_in_tabs'];
				if ( 'yes' === $show_status_in_tabs || 'yes' === $settings['show_types_in_tabs'] ) {
					rhea_get_template_part( 'elementor/widgets/search/fields/top-tabs' );
					$tabs_enable_class = ' rhea-form-tabs-enable ';
				}
				?>
                <div class="rhea-search-form-frame <?php echo esc_attr( $tabs_enable_class ) ?>">
                    <div class="rhea_top_search_fields <?php echo 'yes' === $settings['hide_top_labels'] ? esc_attr( 'rhea-hide-search-labels' ) : ''; ?>">
                        <div class="rhea_top_search_box <?php echo esc_attr( 'rhea_top_fields_count_' . $rhea_top_field_count ) ?>" id="top-<?php echo esc_attr( $this->get_id() ); ?>">
							<?php
							if ( 'yes' === $settings['set_ajax_location'] ) {
								rhea_get_template_part( 'elementor/widgets/search/fields/location-ajax' );
							} else {
								rhea_get_template_part( 'elementor/widgets/search/fields/location' );
							}
							if ( $this->is_rvr_enabled ) {
								rhea_get_template_part( 'elementor/widgets/search/fields/rvr/check-in-out' );
								if ( 'default' === $settings['guests_field_type'] ) {
									rhea_get_template_part( 'elementor/widgets/search/fields/rvr/guest' );
								} else if ( 'guest-types' === $settings['guests_field_type'] ) {
									rhea_get_template_part( 'elementor/widgets/search/fields/rvr/guest-dropdown' );
								}
							}

							if ( 'yes' !== $show_status_in_tabs ) {
								rhea_get_template_part( 'elementor/widgets/search/fields/status' );
							}
							if ( 'yes' !== $settings['show_types_in_tabs'] ) {
								rhea_get_template_part( 'elementor/widgets/search/fields/type' );
							}
							if ( 'yes' == $settings['show_select_fields'] ) {
								rhea_get_template_part( 'elementor/widgets/search/fields/min-max-price' );
							} else {
								rhea_get_template_part( 'elementor/widgets/search/fields/price-slider' );
							}
							rhea_get_template_part( 'elementor/widgets/search/fields/min-beds' );
							rhea_get_template_part( 'elementor/widgets/search/fields/min-baths' );
							rhea_get_template_part( 'elementor/widgets/search/fields/min-garages' );
							rhea_get_template_part( 'elementor/widgets/search/fields/agency' );
							rhea_get_template_part( 'elementor/widgets/search/fields/agent' );
							rhea_get_template_part( 'elementor/widgets/search/fields/min-max-area' );
							rhea_get_template_part( 'elementor/widgets/search/fields/min-max-lot-size' );
							rhea_get_template_part( 'elementor/widgets/search/fields/keyword-search' );
							rhea_get_template_part( 'elementor/widgets/search/fields/property-id' );
							if ( 'yes' === $settings['show_features_dropdown'] ) {
								rhea_get_template_part( 'elementor/widgets/search/fields/property-features-dropdown' );
							}
							$additional_fields = rhea_get_additional_search_fields();
							if ( ! empty( $additional_fields ) ) {
								foreach ( $additional_fields as $additional_field ) {
									$field_name = $additional_field['field_name'];
									$field_key  = $additional_field['field_key'];

									if ( isset( $additional_field['field_options'] ) ) {
										$options = $additional_field['field_options'];

										if ( defined( 'ICL_LANGUAGE_CODE' ) ) {
											$options = explode( ',', apply_filters( 'wpml_translate_single_string', implode( ',', $options ), 'Additional Fields', $field_name . ' Value', ICL_LANGUAGE_CODE ) );
											$options = array_filter( array_map( 'trim', $options ) );
											$options = array_combine( $options, $options );
										}
									}

									if ( defined( 'ICL_LANGUAGE_CODE' ) ) {
										$field_name = apply_filters( 'wpml_translate_single_string', $field_name, 'Additional Fields', $field_name . ' Label', ICL_LANGUAGE_CODE );
									}

									if ( in_array( $field_key, $search_fields_to_display ) ) {
										$field_position = intval( array_search( $field_key, $search_fields_to_display ) ) + 1;

										if ( 'name' === $settings['rhea_select_addition_placeholder'] ) {
											$set_placeholder = $field_name;
										} else {
											$set_placeholder = $settings['additional_field_any_text'];
										}

										$field_id = $field_key . $the_widget_id;
										if ( in_array( $additional_field['field_type'], array( 'text', 'textarea' ) ) ) {
											?>
                                            <div class="rhea_prop_search__option rhea_mod_text_field" data-key-position="<?php echo esc_attr( $field_position ); ?>" style="order: <?php echo esc_attr( $field_position ); ?>">
												<?php
												if ( 'yes' === $settings['show_labels'] ) {
													?>
                                                    <label class="rhea_fields_labels" for="<?php echo esc_attr( $field_id ); ?>"><?php echo esc_html( $field_name ); ?></label>
													<?php
												}
												?>
                                                <span class="rhea-text-field-wrapper">
                                                    <input type="text" name="<?php echo esc_attr( $field_key ); ?>" id="<?php echo esc_attr( $field_id ); ?>" value="<?php echo isset( $_GET[ $field_key ] ) ? esc_attr( $_GET[ $field_key ] ) : ''; ?>" placeholder="<?php echo esc_attr( $set_placeholder ); ?>" />
                                                </span>
                                            </div>
											<?php
										} else {
											?>
                                            <div class="rhea_prop_search__option rhea_prop_search__select" data-key-position="<?php echo esc_attr( $field_position ); ?>" style="order: <?php echo esc_attr( $field_position ); ?>">
												<?php
												if ( 'yes' === $settings['show_labels'] ) {
													?>
                                                    <label class="rhea_fields_labels" for="<?php echo esc_attr( $field_id ); ?>"><?php echo esc_html( $field_name ); ?></label>
													<?php
												}
												?>
                                                <span class="rhea_prop_search__selectwrap">
                                                        <select title="<?php echo esc_html( $field_name ); ?>" id="<?php echo esc_attr( $field_id ); ?>" name="<?php echo esc_attr( $field_key . '[]' ); ?>" class="rhea_multi_select_picker selectpicker show-tick"
                                                            <?php echo 'yes' === $additional_field['multi_select'] ? 'multiple' : ''; ?>>
                                                            <?php
                                                            // Display default select option
                                                            if ( 'yes' !== $additional_field['multi_select'] ) {
	                                                            $selected = empty( $_GET[ $field_key ] ) ? 'selected="selected"' : '';
	                                                            echo '<option value="' . rhea_any_value() . '" ' . $selected . '>' . esc_html( $settings['prefix_placeholder'] . ' ' . $set_placeholder . ' ' . $settings['postfix_placeholder'] ) . '</option>';
                                                            }
                                                            // Display all available select options
                                                            if ( ! empty( $options ) && is_array( $options ) ) {
	                                                            foreach ( $options as $option ) {
		                                                            $selected = ( ! empty( $_GET[ $field_key ] ) && in_array( $option, $_GET[ $field_key ] ) ) ? 'selected="selected"' : '';
		                                                            echo '<option value="' . esc_attr( $option ) . '" ' . $selected . '>' . esc_html( $option ) . '</option>';
	                                                            }
                                                            }
                                                            ?>
                                                        </select>
                                                    </span>
                                            </div>
											<?php
										}
									}
								}
							}
							?>
                        </div>
						<?php
						if ( function_exists( 'inspiry_get_maps_type' ) && 'google-maps' === inspiry_get_maps_type() ) {
							rhea_get_template_part( 'elementor/widgets/search/fields/rvr/geolocation-slider' );
						}

						$rhea_popup_search_button_position = $settings['rhea_popup_search_button_position'];
						if ( 'yes' !== $rhea_popup_search_button_position ) {
							rhea_get_template_part( 'elementor/widgets/search/fields/search-button-top' );
						}
						?>
                    </div>
					<?php
					if ( 'popup' == $settings['rhea_default_advance_state'] ) {
						rhea_get_template_part( 'elementor/widgets/search/fields/search-popup-button-bottom' );
						rhea_get_template_part( 'elementor/widgets/search/parts/advance-form-popup' );
					} else {
						rhea_get_template_part( 'elementor/widgets/search/parts/advance-form-default' );
					}
					?>
                </div>
            </form>
        </div>
		<?php
		if ( function_exists( 'realhomes_currency_switcher_enabled' ) && realhomes_currency_switcher_enabled() ) {
			$get_currencies_data  = realhomes_get_currencies_data();
			$get_current_currency = realhomes_get_current_currency();
			$get_position         = ( $get_currencies_data[ $get_current_currency ]['position'] );
			$get_separator        = $get_currencies_data[ $get_current_currency ]['thousands_sep'];
			$get_symbol           = html_entity_decode( $get_currencies_data[ $get_current_currency ]['symbol'] );
		} else {
			$get_position  = get_option( 'theme_currency_position', 'before' );
			$get_separator = get_option( 'theme_thousands_sep', ',' );
			$get_symbol    = get_option( 'theme_currency_sign', '$' );
		}

		if ( 'before' === $currency_sign_space ) {
			$get_symbol = ' ' . $get_symbol;
		} else if ( 'after' === $currency_sign_space ) {
			$get_symbol = $get_symbol . ' ';
		}

		// check hide empty value based on setting
		$hide_empty = false;
		if ( 'yes' === $settings['hide_empty_location'] ) {
			$hide_empty = true;
		}

		// get hierarchical_locations
		$hierarchical_locations    = ERE_Data::get_hierarchical_locations( $hide_empty );
		$location_select_ids       = rhea_get_location_select_ids( $this->get_id() );
		$select_count              = rhea_get_locations_number( $settings['rhea_select_locations'], 'no' );
		$locations_place_holders   = rhea_location_placeholder(
			$settings['rhea_location_ph_1'],
			$settings['rhea_location_ph_2'],
			$settings['rhea_location_ph_3'],
			$settings['rhea_location_ph_4']
		);
		$query_parameter_locations = $this->query_parameter_locations();
		$any_value                 = rhea_any_value();

		$multi_select = '';
		if ( '1' == $settings['rhea_select_locations'] && 'yes' == $settings['set_multiple_location'] ) {
			$multi_select = 'multiple';
		}

		// Setting Minimum Price Slider Value (Queried/Searched)
		$rhea_searched_price_min = '';
		if ( isset( $_GET['min-price'] ) ) {
			$rhea_searched_price_min = $_GET['min-price'];
		}

		$rhea_searched_price_max = '';
		if ( isset( $_GET['max-price'] ) ) {
			$rhea_searched_price_max = $_GET['max-price'];
		}

		// Establishing the Minimum Price Slider Value from
		// Widget Settings with a fallback to rhea_get_min_max_price
		$rhea_price_min_value = '';
		if ( ! empty( $settings['slider_min_price'] ) ) {
			$rhea_price_min_value = (int)$settings['slider_min_price'];
		} else {
			$rhea_price_min_value = rhea_get_min_max_price( 'min' );
		}

		$rhea_price_max_value = '';
		if ( ! empty( $settings['slider_max_price'] ) ) {
			$rhea_price_max_value = (int)$settings['slider_max_price'];
		} else {
			$rhea_price_max_value = rhea_get_min_max_price( 'max' );
		}

		// set selectors for Status tabs and default status fields
		if ( 'yes' === $show_status_in_tabs ) {
			$status_id = '.rhea-status-tabs-' . esc_attr( $the_widget_id ) . ' input';
		} else {
			$status_id = '#select-status-' . esc_attr( $the_widget_id );
		}
		if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
			?>
            <script type="application/javascript">
                rheaSearchFields( "#rhea-<?php echo esc_attr( $this->get_id() ); ?>",<?php echo intval( $rhea_top_field_count );?>, "#top-<?php echo esc_attr( $this->get_id() ); ?>", "#collapsed-<?php echo esc_attr( $this->get_id() ); ?>" );
                rheaSearchStatusChange( "#rhea-<?php echo esc_attr( $the_widget_id ); ?> .price-for-others", "#rhea-<?php echo esc_attr( $the_widget_id ); ?> .price-for-rent", "<?php echo esc_attr( $status_id ); ?>", "<?php echo esc_attr( $settings['rhea_select_status_for_rent'] )?>" );
                rheaPropertySlider(
                    "#rhea_slider_<?php echo esc_attr( $the_widget_id )?> .rhea_price_slider",
					<?php echo preg_replace( '/[^0-9]/', '', ( rhea_get_plain_property_price( $rhea_price_min_value ) ) );?>,
					<?php echo preg_replace( '/[^0-9]/', '', ( rhea_get_plain_property_price( $rhea_price_max_value ) ) );?>,
                    "<?php echo $get_position;?>",
                    "<?php echo $get_separator; ?>",
                    "<?php echo $get_symbol; ?>",
                    "<?php echo $rhea_searched_price_min; ?>",
                    "<?php echo $rhea_searched_price_max; ?>"
                );
                rheaSearchAdvanceState( "#advance_button_<?php echo esc_attr( $this->get_id() ); ?>", "#collapsed_wrapper_<?php echo esc_attr( $this->get_id() ); ?>" );
                rheaSearchAdvanceState( "#advance_bottom_button_<?php echo esc_attr( $this->get_id() ); ?>", "#collapsed_wrapper_<?php echo esc_attr( $this->get_id() ); ?>" );
                rheaFeaturesState( "#rhea_features_<?php echo esc_attr( $the_widget_id );?> .rhea_open_more_features", "#rhea_features_<?php echo esc_attr( $the_widget_id );?> .rhea-more-options-wrapper" );
                rheaLocationsHandler(<?php echo json_encode( $hierarchical_locations )?>,
					<?php echo json_encode( $locations_place_holders )?>,
					<?php echo json_encode( $location_select_ids )?>,
					<?php echo json_encode( $query_parameter_locations )?>,
					<?php echo json_encode( $select_count )?>,
					<?php echo json_encode( $any_value )?>,
					<?php echo json_encode( $multi_select )?>
                );
                rheaSelectPicker( "<?php echo "#rhea-" . $this->get_id(); ?> .rhea_multi_select_picker" );
                rheaSelectPicker( "<?php echo "#rhea-" . $this->get_id(); ?> .rhea_multi_select_picker_location" );
                minMaxPriceValidation( "#select-min-price-<?php echo esc_attr( $the_widget_id ); ?>", "#select-max-price-<?php echo esc_attr( $the_widget_id ); ?>" );
                minMaxRentPriceValidation( "#select-min-price-for-rent-<?php echo esc_attr( $the_widget_id ); ?>", "#select-max-price-for-rent-<?php echo esc_attr( $the_widget_id ); ?>" );
                minMaxAreaValidation( "#min-area-<?php echo esc_attr( $the_widget_id ); ?>", "#max-area-<?php echo esc_attr( $the_widget_id ); ?>" );
                minMaxAreaValidation( "#min-lot-size-<?php echo esc_attr( $the_widget_id ); ?>", "#max-lot-size-<?php echo esc_attr( $the_widget_id ); ?>" );

                jQuery( "<?php echo "#rhea-" . $this->get_id(); ?> .rhea_multi_select_picker_location" )
                .on( 'change', function () {
                    jQuery( "<?php echo "#rhea-" . $this->get_id(); ?> .rhea_multi_select_picker_location" )
                    .selectpicker( 'refresh' );

                } );

                rheaAjaxSelect( ".rhea_location_ajax_parent_<?php echo esc_attr( $the_widget_id )?>",
                    "#rhea_ajax_location_<?php echo $the_widget_id?>",
                    '<?php echo admin_url( 'admin-ajax.php' )?>',
                    '<?php echo $settings['hide_empty_location']?>',
                    '<?php echo $settings['sort_location_alphabetically']?>'
                );
                rheaOpenSearchPopup( "#advance_button_<?php echo esc_attr( $the_widget_id ); ?>", "#rhea-popup-<?php echo esc_attr( $the_widget_id ); ?>" );
                rheaOpenSearchPopup( "#advance_popup_bottom_button_<?php echo esc_attr( $the_widget_id ); ?>", "#rhea-popup-<?php echo esc_attr( $the_widget_id ); ?>" );
				<?php if ( $this->is_rvr_enabled && 'guest-types' === $settings['guests_field_type']) { ?>
                rvrGuestsFieldsCounter( ".guests-field-<?php echo esc_attr( $the_widget_id )?>", ".guests-field-wrapper-<?php echo esc_attr( $the_widget_id )?>" );
				<?php } ?>
            </script>
			<?php
		} else {
			?>
            <script type="application/javascript">
                jQuery( document ).bind( "ready", function () {
                    rheaSearchFields( "#rhea-<?php echo esc_attr( $this->get_id() ); ?>",<?php echo intval( $rhea_top_field_count );?>, "#top-<?php echo esc_attr( $this->get_id() ); ?>", "#collapsed-<?php echo esc_attr( $this->get_id() ); ?>" );
                    rheaSearchStatusChange( "#rhea-<?php echo esc_attr( $the_widget_id ); ?> .price-for-others", "#rhea-<?php echo esc_attr( $the_widget_id ); ?> .price-for-rent", "<?php echo esc_attr( $status_id ); ?>", "<?php echo esc_attr( $settings['rhea_select_status_for_rent'] )?>" );
                    rheaPropertySlider(
                        "#rhea_slider_<?php echo esc_attr( $the_widget_id )?> .rhea_price_slider",
						<?php echo preg_replace( '/[^0-9]/', '', ( rhea_get_plain_property_price( $rhea_price_min_value ) ) );?>,
						<?php echo preg_replace( '/[^0-9]/', '', ( rhea_get_plain_property_price( $rhea_price_max_value ) ) );?>,
                        "<?php echo $get_position;?>",
                        "<?php echo $get_separator; ?>",
                        "<?php echo $get_symbol; ?>",
                        "<?php echo $rhea_searched_price_min; ?>",
                        "<?php echo $rhea_searched_price_max; ?>"
                    );
                    rheaSearchAdvanceState( "#advance_button_<?php echo esc_attr( $this->get_id() ); ?>", "#collapsed_wrapper_<?php echo esc_attr( $this->get_id() ); ?>" );
                    rheaSearchAdvanceState( "#advance_bottom_button_<?php echo esc_attr( $this->get_id() ); ?>", "#collapsed_wrapper_<?php echo esc_attr( $this->get_id() ); ?>" );
                    rheaFeaturesState( "#rhea_features_<?php echo esc_attr( $the_widget_id );?> .rhea_open_more_features", "#rhea_features_<?php echo esc_attr( $the_widget_id );?> .rhea-more-options-wrapper" );
                    rheaLocationsHandler(<?php echo json_encode( $hierarchical_locations )?>,
						<?php echo json_encode( $locations_place_holders )?>,
						<?php echo json_encode( $location_select_ids )?>,
						<?php echo json_encode( $query_parameter_locations )?>,
						<?php echo json_encode( $select_count )?>,
						<?php echo json_encode( $any_value )?>,
						<?php echo json_encode( $multi_select )?>
                    );
                    rheaSelectPicker( "<?php echo "#rhea-" . $this->get_id(); ?> select.rhea_multi_select_picker" );
                    rheaSelectPicker( "<?php echo "#rhea-" . $this->get_id(); ?> select.rhea_multi_select_picker_location" );
                    minMaxPriceValidation( "#select-min-price-<?php echo esc_attr( $the_widget_id ); ?>", "#select-max-price-<?php echo esc_attr( $the_widget_id ); ?>" );
                    minMaxRentPriceValidation( "#select-min-price-for-rent-<?php echo esc_attr( $the_widget_id ); ?>", "#select-max-price-for-rent-<?php echo esc_attr( $the_widget_id ); ?>" );
                    minMaxAreaValidation( "#min-area-<?php echo esc_attr( $the_widget_id ); ?>", "#max-area-<?php echo esc_attr( $the_widget_id ); ?>" );
                    minMaxAreaValidation( "#min-lot-size-<?php echo esc_attr( $the_widget_id ); ?>", "#max-lot-size-<?php echo esc_attr( $the_widget_id ); ?>" );

                    jQuery( "<?php echo "#rhea-" . $this->get_id(); ?> .rhea_multi_select_picker_location" )
                    .on( 'change', function () {
                        setTimeout( function () {
                            jQuery( "<?php echo "#rhea-" . $this->get_id(); ?> .rhea_multi_select_picker_location" )
                            .selectpicker( 'refresh' );
                        }, 500 );
                    } );

                    rheaAjaxSelect( ".rhea_location_ajax_parent_<?php echo esc_attr( $the_widget_id )?>",
                        "#rhea_ajax_location_<?php echo $the_widget_id?>",
                        '<?php echo admin_url( 'admin-ajax.php' )?>',
                        '<?php echo $settings['hide_empty_location'] == 'yes' ? $settings['hide_empty_location'] : 'no' ?>',
                        '<?php echo $settings['sort_location_alphabetically'] == 'yes' ? $settings['sort_location_alphabetically'] : 'no' ?>'
                    );

                    rheaOpenSearchPopup( "#advance_button_<?php echo esc_attr( $the_widget_id ); ?>", "#rhea-popup-<?php echo esc_attr( $the_widget_id ); ?>" );
                    rheaOpenSearchPopup( "#advance_popup_bottom_button_<?php echo esc_attr( $the_widget_id ); ?>", "#rhea-popup-<?php echo esc_attr( $the_widget_id ); ?>" );
					<?php if ( $this->is_rvr_enabled && 'guest-types' === $settings['guests_field_type'] ) { ?>
                    rvrGuestsFieldsCounter( ".guests-field-<?php echo esc_attr( $the_widget_id )?>", ".guests-field-wrapper-<?php echo esc_attr( $the_widget_id )?>" );
					<?php } ?>
                } );
            </script>
			<?php
		}
	}
}
