<?php
/**
 * Single Property Additional Details Widget V2.
 *
 * @since 2.4.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RHEA_Single_Property_Additional_Details_V2 extends \Elementor\Widget_Base {

	use RHEA_Single_Property_V2_Title_Section_Trait;

	public function get_name() {
		return 'rh-single-property-additional-details-v2';
	}

	public function get_title() {
		return esc_html__( 'RH: Single Property Additional Details V2', RHEA_TEXT_DOMAIN );
	}

	public function get_icon() {
		// More classes for icons can be found at https://pojome.github.io/elementor-icons/
		return 'eicon-bullet-list rh-ultra-widget';
	}

	public function get_categories() {
		return [ 'ultra-realhomes-single-property' ];
	}

	protected function register_controls() {

		$this->title_section_content_tab_controls( esc_html__( 'Additional Details', RHEA_TEXT_DOMAIN ) );

		$this->title_section_style_tab_controls();

		$this->start_controls_section(
			'property_additional_details_section_styles',
			[
				'label' => esc_html__( 'Property Additional Details', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'container_heading',
			[
				'label' => esc_html__( 'Container', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::HEADING,
			]
		);

		$this->add_responsive_control(
			'container_padding',
			[
				'label'     => esc_html__( 'Padding', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-additional-details-v2-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'container_border_radius',
			[
				'label'     => esc_html__( 'Border Radius', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-additional-details-v2-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'container_bg',
			[
				'label'     => esc_html__( 'Background', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-additional-details-v2-inner' => 'background-color: {{VALUE}}',
				],
				'separator' => 'after'
			]
		);

		$this->add_control(
			'single_column',
			[
				'label'        => esc_html__( 'Single Column', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
				'selectors'    => [
					'{{WRAPPER}} .rh-single-property-additional-details-v2 .rh-single-property-additional-details-v2-list:before' => 'display: none;',
					'{{WRAPPER}} .rh-single-property-additional-details-v2 .rh-single-property-additional-details-v2-list'        => 'flex-direction: column;',
					'{{WRAPPER}} .rh-single-property-additional-details-v2 .rh-single-property-additional-details-v2-list li'     => 'width: 100%;',
				],
			]
		);

		$this->add_responsive_control(
			'detail_list_items_width',
			[
				'label'     => esc_html__( 'Columns Width', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-additional-details-v2-list li' => 'flex: 0 0 {{SIZE}}{{UNIT}};  max-width: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'single_column' => '',
				]
			]
		);

		$this->add_control(
			'list_title_heading',
			[
				'label' => esc_html__( 'Titles', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::HEADING,
			]
		);

		$this->add_control(
			'list_title_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} li .title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'label'    => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} li .title',
			]
		);

		$this->add_control(
			'list_value_heading',
			[
				'label'     => esc_html__( 'Values', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->add_control(
			'list_values_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} li .value' => 'color: {{VALUE}}',
				],
			]
		);


		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'value_typography',
				'label'    => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} li .value',
			]
		);

		$this->add_control(
			'list_vertical_line_heading',
			[
				'label'     => esc_html__( 'Vertical Line', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::HEADING,
				'separator' => 'before'
			]
		);

		$this->add_control(
			'list_vertical_line_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-additional-details-v2-list:before' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'list_vertical_line_space',
			[
				'label'     => esc_html__( 'Space', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-additional-details-v2' => '--additional-details-list-column-gap: {{SIZE}}px',
				],
			]
		);

		$this->add_responsive_control(
			'list_vertical_line_width',
			[
				'label'     => esc_html__( 'Width', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-additional-details-v2-list:before' => 'width: {{SIZE}}px',
				],
			]
		);

		$this->add_responsive_control(
			'list_vertical_line_height',
			[
				'label'     => esc_html__( 'Height', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min'  => 0,
						'max'  => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-additional-details-v2-list:before' => 'height: {{SIZE}}px',
				],
			]
		);

		$this->add_responsive_control(
			'list_vertical_line_border_radius',
			[
				'label'     => esc_html__( 'Border Radius', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min'  => 0,
						'max'  => 50,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-additional-details-v2-list:before' => 'border-radius: {{SIZE}}px',
				],
			]
		);

		$this->add_responsive_control(
			'list_vertical_line_margin',
			[
				'label'     => esc_html__( 'Margin', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .rh-single-property-additional-details-v2-list:before' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
		$settings    = $this->get_settings_for_display();
		$widget_id   = $this->get_id();
		$property_id = get_the_ID();

		if ( rhea_is_preview_mode() && rhea_get_sample_property_id() ) {
			// Sample property id for editor side,
			$property_id = rhea_get_sample_property_id();
		}

		// Migrate property additional details from old metabox key to new key.
		ere_additional_details_migration( $property_id );

		$additional_details = get_post_meta( $property_id, 'REAL_HOMES_additional_details_list', true );
		if ( ! empty( $additional_details ) ) {
			$additional_details = array_filter( $additional_details ); // Remove empty values.
		}

		if ( empty( $additional_details ) ) {
			rhea_print_no_result_for_editor();

			return;
		}
		?>
        <div id="rh-single-property-additional-details-v2-<?php echo esc_attr( $widget_id ); ?>" class="rh-single-property-additional-details-v2 <?php realhomes_printable_section( 'additional-details' ); ?>">
			<?php
			if ( ! empty( $settings['section_title'] ) ) {
				?>
                <h4 class="rh-single-property-section-heading rh-single-property-section-heading-common"><?php echo esc_html( $settings['section_title'] ); ?></h4>
				<?php
			}
			?>
            <div class="rh-single-property-additional-details-v2-inner">
				<?php
				if ( ! empty( $additional_details ) ) {
					$output = '<ul class="rh-single-property-additional-details-v2-list">';
					foreach ( $additional_details as $detail ) {
						$output .= '<li>';
						$output .= sprintf( '<span class="title">%s</span>', esc_html( $detail[0] ) );
						$output .= sprintf( '<span class="value">%s</span>', esc_html( $detail[1] ) );
						$output .= '</li>';
					}
					$output .= '</ul>';
					echo $output;
				}
				?>
            </div>
        </div>
		<?php
	}
}