<?php
/**
 * Elementor Testimonials Widget V7.
 *
 * @since 2.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RHEA_Testimonials_Widget_V7 extends \Elementor\Widget_Base {
	public function get_name() {
		return 'rh-testimonials-widget-v7';
	}

	public function get_title() {
		return esc_html__( 'RH: Testimonials V7', RHEA_TEXT_DOMAIN );
	}

	public function get_icon() {
		return 'eicon-testimonial rh-ultra-widget';
	}

	public function get_categories() {
		return [ 'ultra-real-homes' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'content_section',
			[
				'label' => esc_html__( 'Testimonials', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'show_heading',
			[
				'label'        => esc_html__( 'Show Heading', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
			]
		);

		$this->add_control(
			'heading',
			[
				'label'     => esc_html__( 'Section Heading', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::TEXT,
				'condition' => [
					'show_heading' => 'yes',
				],
			]
		);

		$this->add_control(
			'show_image',
			[
				'label'        => esc_html__( 'Show Image', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'no',
				'separator'    => 'before',
			]
		);

		$this->add_control(
			'section_bg',
			[
				'label'     => esc_html__( 'Section Image', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::MEDIA,
				'default'   => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'show_image' => 'yes',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Image_Size::get_type(),
			[
				'name'      => 'thumbnail',
				'default'   => 'post-featured-image',
				'condition' => [
					'show_image' => 'yes',
				],
			]
		);

		$this->add_control(
			'show_quote',
			[
				'label'        => esc_html__( 'Show Quote Icon', RHEA_TEXT_DOMAIN ),
				'type'         => \Elementor\Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
				'label_off'    => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				'return_value' => 'yes',
				'default'      => 'yes',
				'condition'    => [
					'show_image' => 'yes',
				],
			]
		);

		$testimonial_repeater = new \Elementor\Repeater();

		$testimonial_repeater->add_control(
			'author_name',
			[
				'label' => esc_html__( 'Author Name', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::TEXT,
			]
		);

		$testimonial_repeater->add_control(
			'author_designation',
			[
				'label'       => esc_html__( 'Author Designation', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::TEXT,
				'description' => esc_html__( 'For example: Director of Automatic', RHEA_TEXT_DOMAIN ),
			]
		);

		$testimonial_repeater->add_control(
			'testimonial_text',
			[
				'label' => esc_html__( 'Testimonial Text', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::TEXTAREA,
			]
		);

		$testimonial_repeater->add_control(
			'rating',
			[
				'label'   => esc_html__( 'Rating', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::NUMBER,
				'min'     => 1,
				'max'     => 5,
				'step'    => 1,
				'default' => 5,
			]
		);

		$this->add_control(
			'testimonials',
			[
				'label'       => esc_html__( 'Add Testimonials', RHEA_TEXT_DOMAIN ),
				'type'        => \Elementor\Controls_Manager::REPEATER,
				'fields'      => $testimonial_repeater->get_controls(),
				'separator'   => 'before',
				'default'     => [
					[
						'author_name'        => esc_html( 'Melissa William' ),
						'author_designation' => esc_html( 'James Estate Agents' ),
						'testimonial_text'   => esc_html( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type  book There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which don\'t look even slightly believable.' ),
						'rating'             => 5,
					],
					[
						'author_name'        => esc_html( 'Jone Deo' ),
						'author_designation' => esc_html( 'James Estate Agents' ),
						'testimonial_text'   => esc_html( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it.' ),
						'rating'             => 4,
					],
				],
				'title_field' => ' {{{ author_name }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'settings',
			[
				'label' => esc_html__( 'Carousel', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'autoplay',
			[
				'label'              => esc_html__( 'Autoplay', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::SELECT,
				'default'            => 'yes',
				'options'            => [
					'yes' => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
					'no'  => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				],
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'pause_on_hover',
			[
				'label'              => esc_html__( 'Pause on Hover', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::SELECT,
				'default'            => 'yes',
				'options'            => [
					'yes' => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
					'no'  => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				],
				'condition'          => [
					'autoplay' => 'yes',
				],
				'render_type'        => 'none',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'pause_on_interaction',
			[
				'label'              => esc_html__( 'Pause on Interaction', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::SELECT,
				'default'            => 'yes',
				'options'            => [
					'yes' => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
					'no'  => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				],
				'condition'          => [
					'autoplay' => 'yes',
				],
				'frontend_available' => true,
			]
		);

		// Loop requires a re-render so no 'render_type = none'
		$this->add_control(
			'infinite',
			[
				'label'              => esc_html__( 'Infinite Loop', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::SELECT,
				'default'            => 'yes',
				'options'            => [
					'yes' => esc_html__( 'Yes', RHEA_TEXT_DOMAIN ),
					'no'  => esc_html__( 'No', RHEA_TEXT_DOMAIN ),
				],
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'autoplay_speed',
			[
				'label'              => esc_html__( 'Autoplay Speed', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::NUMBER,
				'default'            => 3000,
				'condition'          => [
					'autoplay' => 'yes',
				],
				'render_type'        => 'none',
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'speed',
			[
				'label'              => esc_html__( 'Animation Speed', RHEA_TEXT_DOMAIN ),
				'type'               => \Elementor\Controls_Manager::NUMBER,
				'default'            => 500,
				'frontend_available' => true,
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_title_section',
			[
				'label'     => esc_html__( 'Section Heading', RHEA_TEXT_DOMAIN ),
				'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_heading' => 'yes',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'section_title_typography',
				'label'    => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh-testimonials-widget-v7-section-heading',
			]
		);

		$this->add_control(
			'section_title_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-testimonials-widget-v7-section-heading' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'section_title_max_width',
			[
				'label'     => esc_html__( 'Max Width', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh-testimonials-widget-v7-section-heading' => 'max-width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'section_title_margin',
			[
				'label'     => esc_html__( 'Margin', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .rh-testimonials-widget-v7-section-heading' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_image_section',
			[
				'label'     => esc_html__( 'Section Image', RHEA_TEXT_DOMAIN ),
				'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
				'condition' => [
					'show_image' => 'yes',
				],
			]
		);

		$this->add_responsive_control(
			'section_image_width',
			[
				'label'     => esc_html__( 'Width', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .rh-testimonials-widget-v7-bg' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'section_image_height',
			[
				'label'     => esc_html__( 'Height', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .rh-testimonials-widget-v7-bg' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'quote_icon_heading',
			[
				'label' => esc_html__( 'Quote Icon', RHEA_TEXT_DOMAIN ),
				'type'  => \Elementor\Controls_Manager::HEADING,
			]
		);

		$this->add_control(
			'quote_icon_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-testimonials-widget-v7-quote-icon svg path' => 'stroke: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'quote_icon_size',
			[
				'label'     => esc_html__( 'Size', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh-testimonials-widget-v7-quote-icon svg' => 'width: {{SIZE}}{{UNIT}}; height: auto;',
				],
			]
		);

		$this->add_responsive_control(
			'quote_icon_margin',
			[
				'label'     => esc_html__( 'Margin', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .rh-testimonials-widget-v7-quote-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'testimonial_card_section',
			[
				'label' => esc_html__( 'Testimonial Card', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'testimonial_card_max_width',
			[
				'label'     => esc_html__( 'Max Width', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 1500,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .rh-testimonials-widget-v7-carousel' => 'max-width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'testimonial_card_margin',
			[
				'label'     => esc_html__( 'Margin', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .rh-testimonials-widget-v7-carousel' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'testimonial_card_padding',
			[
				'label'     => esc_html__( 'Padding', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .rh-testimonials-widget-v7-carousel' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'testimonial_card_bg_color',
			[
				'label'     => esc_html__( 'Background Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-testimonials-widget-v7-carousel' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name'     => 'testimonial_card_box_shadow',
				'label'    => esc_html__( 'Box Shadow', RHEA_TEXT_DOMAIN ),
				'selector' => '{{WRAPPER}} .rh-testimonials-widget-v7-carousel',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'testimonial_card_author_name_section',
			[
				'label' => esc_html__( 'Author Name', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'testimonial_card_author_name_typography',
				'label'    => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh-testimonials-widget-v7-author-name',
			]
		);

		$this->add_control(
			'testimonial_card_author_name_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-testimonials-widget-v7-author-name' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'testimonial_card_author_name_margin_bottom',
			[
				'label'     => esc_html__( 'Margin Bottom', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 150,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .rh-testimonials-widget-v7-author-name' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'testimonial_card_author_designation_section',
			[
				'label' => esc_html__( 'Author Designation', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'testimonial_card_author_designation_typography',
				'label'    => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh-testimonials-widget-v7-author-designation',
			]
		);

		$this->add_control(
			'testimonial_card_author_designation_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-testimonials-widget-v7-author-designation' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'testimonial_card_author_designation_margin_bottom',
			[
				'label'     => esc_html__( 'Margin Bottom', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 150,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .rh-testimonials-widget-v7-author-designation' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'testimonial_card_text_section',
			[
				'label' => esc_html__( 'Testimonial Text', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name'     => 'testimonial_card_text_typography',
				'label'    => esc_html__( 'Typography', RHEA_TEXT_DOMAIN ),
				'global'   => [
					'default' => \Elementor\Core\Kits\Documents\Tabs\Global_Typography::TYPOGRAPHY_PRIMARY,
				],
				'selector' => '{{WRAPPER}} .rh-testimonials-widget-v7-text',
			]
		);

		$this->add_control(
			'testimonial_card_text_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-testimonials-widget-v7-text' => 'color: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'testimonial_card_rating_section',
			[
				'label' => esc_html__( 'Rating Stars', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'testimonial_card_rating_margin_top',
			[
				'label'     => esc_html__( 'Margin Top', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 150,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .rh-testimonials-widget-v7-rating' => 'margin-top: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'testimonial_card_rating_start_color',
			[
				'label'     => esc_html__( 'Star Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-testimonials-widget-v7-rating svg path' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'testimonial_card_rating_active_star_color',
			[
				'label'     => esc_html__( 'Active Start Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-testimonials-widget-v7-rating .rating-stars-colored path' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'arrow_navigation_section',
			[
				'label' => esc_html__( 'Arrow Navigation', RHEA_TEXT_DOMAIN ),
				'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'arrow_navigation_margin',
			[
				'label'     => esc_html__( 'Margin', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .rh-testimonials-widget-v7-nav' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'arrow_navigation_padding',
			[
				'label'     => esc_html__( 'Padding', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::DIMENSIONS,
				'selectors' => [
					'{{WRAPPER}} .rh-testimonials-widget-v7-nav' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'arrow_button_gap',
			[
				'label'     => esc_html__( 'Gap', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 1000,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh-testimonials-widget-v7-nav' => 'gap: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'arrow_button_size',
			[
				'label'     => esc_html__( 'Size', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh-testimonials-widget-v7-nav a' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'arrow_button_border_radius',
			[
				'label'     => esc_html__( 'Border Radius', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'range'     => [
					'px' => [
						'min' => 0,
						'max' => 500,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .rh-testimonials-widget-v7-nav a' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'arrows_color',
			[
				'label'     => esc_html__( 'Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-testimonials-widget-v7-nav svg path' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'arrows_hover_color',
			[
				'label'     => esc_html__( 'Hover Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-testimonials-widget-v7-nav a:not(.slick-disabled):hover svg path' => 'fill: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'arrows_button_bg_color',
			[
				'label'     => esc_html__( 'Background Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-testimonials-widget-v7-nav a' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'arrows_button_bg_hover_color',
			[
				'label'     => esc_html__( 'Background Hover Color', RHEA_TEXT_DOMAIN ),
				'type'      => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .rh-testimonials-widget-v7-nav a:not(.slick-disabled):hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render() {
		global $settings, $widget_id;

		$settings     = $this->get_settings_for_display();
		$widget_id    = $this->get_id();
		$testimonials = $settings['testimonials'];

		if ( ! $testimonials ) {
			return '';
		}
		?>
        <div id="rh-testimonials-widget-v7-<?php echo esc_attr( $widget_id ); ?>" class="rh-testimonials-widget-v7">
            <div class="rh-testimonials-widget-v7-bg-wrapper">
				<?php
				if ( 'yes' === $settings['show_image'] ) {
					if ( 'yes' === $settings['show_quote'] ) {
						?>
                        <div class="rh-testimonials-widget-v7-quote-icon">
                            <svg width="166" height="150" fill="none" viewBox="0 0 166 150" xmlns="http://www.w3.org/2000/svg">
                                <path d="M1.86565 105.593C1.95479 107.828 2.1509 110.081 2.45398 112.351C4.43288 127.477 13.1508 140.796 27.7519 146.249C29.0533 146.732 30.3904 147.143 31.7632 147.483C34.8296 148.252 38.003 148.627 41.1764 148.627C62.6947 148.627 80.1305 131.142 80.1305 109.562C80.1305 89.6454 65.262 73.1969 46.0256 70.8012C46.0256 70.8012 49.3416 35.4906 64.7271 8.69036L45.3659 1.95007C41.5864 6.93825 38.0743 12.1588 34.6513 17.3973C27.1101 28.9827 20.1393 40.9973 14.3096 53.5303C6.6079 69.9966 1.08122 87.3926 1.86565 105.593Z" stroke="#1A1A1A" stroke-width="2.125" stroke-miterlimit="10" />
                                <path d="M86.0409 105.593C86.1301 107.828 86.3262 110.081 86.6293 112.351C88.6082 127.477 97.3261 140.796 111.927 146.249C113.229 146.732 114.566 147.143 115.938 147.483C119.005 148.252 122.178 148.627 125.352 148.627C146.87 148.627 164.306 131.142 164.306 109.562C164.306 89.6454 149.437 73.1969 130.201 70.8012C130.201 70.8012 133.517 35.4906 148.902 8.69036L129.541 1.95007C125.762 6.93825 122.25 12.1588 118.827 17.3973C111.285 28.9827 104.315 40.9973 98.4849 53.5303C90.7832 69.9966 85.2565 87.3926 86.0409 105.593Z" stroke="#1A1A1A" stroke-width="2.125" stroke-miterlimit="10" />
                            </svg>
                        </div>
						<?php
					}

					if ( ! empty( $settings['section_bg']['id'] ) ) {
						$author_thumbnail = wp_get_attachment_image_url( $settings['section_bg']['id'], $settings['thumbnail_size'] );
						?>
                        <div class="rh-testimonials-widget-v7-bg" style="background-image: url('<?php echo esc_url( $author_thumbnail ); ?>');"></div>
						<?php
					}
				}
				?>
            </div>
			<?php
			if ( 'yes' === $settings['show_heading'] && ! empty( $settings['heading'] ) ) {
				?>
                <h3 class="rh-testimonials-widget-v7-section-heading"><?php echo esc_html( $settings['heading'] ); ?></h3>
				<?php
			}
			?>
            <div class="rh-testimonials-widget-v7-carousel-wrapper">
                <div class="rh-testimonials-widget-v7-nav">
                    <a class="rh-testimonials-widget-v7-carousel-nav-prev rh-testimonials-widget-v7-carousel-nav" aria-label="Previous">
                        <svg width="15" height="24" viewBox="0 0 15 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M1.14746 13.1914C0.511067 12.5551 0.511067 11.6005 1.14746 11.0277L11.3298 0.845418C11.9025 0.209024 12.8571 0.209025 13.4298 0.845418C14.0662 1.41817 14.0662 2.37276 13.4298 2.94552L4.32943 12.0459L13.4935 21.21C14.0662 21.7828 14.0662 22.7373 13.4935 23.3101C12.8571 23.9465 11.9025 23.9465 11.3298 23.3101L1.14746 13.1914Z" fill="#6E767E" />
                        </svg>
                    </a>

                    <a class="rh-testimonials-widget-v7-carousel-nav-next rh-testimonials-widget-v7-carousel-nav" aria-label="Next">
                        <svg width="14" height="25" viewBox="0 0 14 25" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M13.228 11.2048C13.8644 11.8412 13.8644 12.7958 13.228 13.3685L3.04574 23.5508C2.47298 24.1872 1.51839 24.1872 0.945639 23.5508C0.309245 22.9781 0.309245 22.0235 0.945639 21.4507L10.0461 12.3503L0.881998 3.18624C0.309245 2.61349 0.309244 1.6589 0.881998 1.08614C1.51839 0.449748 2.47298 0.449748 3.04574 1.08614L13.228 11.2048Z" fill="#ECECEC" />
                        </svg>
                    </a>
                </div>
                <div class="rh-testimonials-widget-v7-carousel">
					<?php
					$star_svg = '<svg class="rating-stars" width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">';
					$star_svg .= '<path d="M6.71387 0.57959L8.28547 5.41647H13.3713L9.25677 8.40583L10.8284 13.2427L6.71387 10.2534L2.59937 13.2427L4.17097 8.40583L0.0564713 5.41647H5.14227L6.71387 0.57959Z" fill="#D9D9D9"/>';
					$star_svg .= '</svg>';

					foreach ( $testimonials as $testimonial ) {
						?>
                        <div class="rh-testimonials-widget-v7-wrapper">
                            <div class="rh-testimonials-widget-v7-author-info">
								<?php
								if ( ! empty( $testimonial['author_name'] ) ) {
									?>
                                    <h4 class="rh-testimonials-widget-v7-author-name"><?php echo esc_html( $testimonial['author_name'] ) ?></h4>
									<?php
								}

								if ( ! empty( $testimonial['author_designation'] ) ) {
									?>
                                    <span class="rh-testimonials-widget-v7-author-designation"><?php echo esc_html( $testimonial['author_designation'] ) ?></span>
									<?php
								}
								?>
                            </div>
							<?php
							if ( ! empty( $testimonial['testimonial_text'] ) ) {
								?>
                                <div class="rh-testimonials-widget-v7-content">
                                    <p class="rh-testimonials-widget-v7-text"><?php echo esc_html( $testimonial['testimonial_text'] ); ?></p>
                                </div>
								<?php
							}
							?>
							<?php
							if ( ! empty( $testimonial['rating'] ) && $star_svg ) {
								$rating = intval( $testimonial['rating'] );
								?>
                                <div class="rh-testimonials-widget-v7-rating">
									<?php
									for ( $i = 1; $i <= 5; $i++ ) {
										if ( $i <= $rating ) {
											echo str_replace( 'rating-stars', 'rating-stars-colored', $star_svg );
										} else {
											echo $star_svg;
										}
									}
									?>
                                </div>
								<?php
							}
							?>
                        </div>
						<?php
					}

					$carousel_options                       = array();
					$carousel_options['speed']              = (int)$settings['speed'];
					$carousel_options['autoplaySpeed']      = (int)$settings['autoplay_speed'];
					$carousel_options['autoplay']           = ( 'yes' == $settings['autoplay'] );
					$carousel_options['pauseOnHover']       = ( 'yes' == $settings['pause_on_hover'] );
					$carousel_options['pauseOnInteraction'] = ( 'yes' == $settings['pause_on_interaction'] );
					$carousel_options['infinite']           = ( 'yes' == $settings['infinite'] );
					?>
                </div>
            </div>
        </div>
        <script>
            'use strict';
            jQuery( document ).ready( function () {
                const settings              = <?php echo wp_json_encode( $carousel_options ); ?>,
                      testimonialsContainer = jQuery( "#rh-testimonials-widget-v7-<?php echo esc_html( $widget_id ); ?>" ),
                      testimonialsCarousel  = testimonialsContainer.find( ".rh-testimonials-widget-v7-carousel" ),
                      options               = {
                          speed              : settings.speed,
                          infinite           : settings.infinite,
                          autoplay           : settings.autoplay,
                          autoplaySpeed      : settings.autoplaySpeed,
                          pauseOnHover       : settings.pauseOnHover,
                          pauseOnInteraction : settings.pauseOnInteraction,
                          slidesToShow       : 1,
                          slidesToScroll     : 1,
                          fade               : true,
                          arrows             : true,
                          dots               : false,
                          vertical           : false,
                          mobileFirst        : true,
                          adaptiveHeight     : true,
                          prevArrow          : testimonialsContainer.find( '.rh-testimonials-widget-v7-carousel-nav-prev' ),
                          nextArrow          : testimonialsContainer.find( '.rh-testimonials-widget-v7-carousel-nav-next' ),
                          rtl                : rheaIsRTL()
                      };

                if ( jQuery().slick ) {
                    testimonialsCarousel.slick( options );
                }
            } );
        </script>
		<?php
	}
}
