<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class RHEA_Hero_WPML_Translate {

	public function __construct() {
		add_filter( 'wpml_elementor_widgets_to_translate', [
			$this,
			'inspiry_hero_widget_to_translate'
		] );
	}

	public function inspiry_hero_widget_to_translate( $widgets ) {

		$widgets['inspiry-hero-widget'] = [
			'conditions'        => [ 'widgetType' => 'inspiry-hero-widget' ],
			'fields'            => [
				[
					'field'       => 'section_title',
					'type'        => esc_html__( 'Hero Widget: Title', RHEA_TEXT_DOMAIN ),
					'editor_type' => 'LINE'
				],
				[
					'field'       => 'section_description',
					'type'        => esc_html__( 'Hero Widget: Description', RHEA_TEXT_DOMAIN ),
					'editor_type' => 'AREA'
				],
				[
					'field'       => 'form_title',
					'type'        => esc_html__( 'Hero Widget: Form Title', RHEA_TEXT_DOMAIN ),
					'editor_type' => 'LINE'
				],
				[
					'field'       => 'location_field_label',
					'type'        => esc_html__( 'Hero Widget: Location Field Label', RHEA_TEXT_DOMAIN ),
					'editor_type' => 'LINE'
				],
				[
					'field'       => 'location_field_placeholder',
					'type'        => esc_html__( 'Hero Widget: Location Field Placeholder Text', RHEA_TEXT_DOMAIN ),
					'editor_type' => 'LINE'
				],
				[
					'field'       => 'type_field_label',
					'type'        => esc_html__( 'Hero Widget: Type Field label', RHEA_TEXT_DOMAIN ),
					'editor_type' => 'LINE'
				],
				[
					'field'       => 'type_field_placeholder',
					'type'        => esc_html__( 'Hero Widget: Type Field Placeholder Text', RHEA_TEXT_DOMAIN ),
					'editor_type' => 'LINE'
				],
				[
					'field'       => 'guest_field_label',
					'type'        => esc_html__( 'Hero Widget: Guest Field Label', RHEA_TEXT_DOMAIN ),
					'editor_type' => 'LINE'
				],
				[
					'field'       => 'guest_field_placeholder',
					'type'        => esc_html__( 'Hero Widget: Guest Field Placeholder Text', RHEA_TEXT_DOMAIN ),
					'editor_type' => 'LINE'
				],
				[
					'field'       => 'submit_button_text',
					'type'        => esc_html__( 'Hero Widget: Submit Button Text', RHEA_TEXT_DOMAIN ),
					'editor_type' => 'LINE'
				],
				[
					'field'       => 'testimonial_name',
					'type'        => esc_html__( 'Hero Widget: Author Name', RHEA_TEXT_DOMAIN ),
					'editor_type' => 'LINE'
				],
				[
					'field'       => 'testimonial_content',
					'type'        => esc_html__( 'Hero Widget: Testimonial Content', RHEA_TEXT_DOMAIN ),
					'editor_type' => 'AREA'
				],
			],
		];

		return $widgets;
	}
}

new RHEA_Hero_WPML_Translate();