<?php
/**
 * Custom Elementor Icons
 *
 * @since 2.4.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

class RHEA_Elementor_Icons {
	public function generate_elementor_icon( $icon_key, $settings, $class = '' ) {
		$button_icon = $settings[ $icon_key ];
		if ( is_array( $button_icon['value'] ) && ! empty( $button_icon['value']['url'] ) ) {
			?>
            <span class="rhea-elementor-icon <?php echo esc_attr( $class ) ?>">
			<?php
			\Elementor\Icons_Manager::render_icon( $button_icon, [ 'aria-hidden' => 'true' ] );
			?>
            </span>
			<?php
		} else if ( ! empty( $button_icon['library'] && ! empty( $button_icon['value'] ) ) ) {
			?>
        <i class="rhea-elementor-icon <?php echo esc_attr( $class . ' ' . $button_icon['library'] . ' ' . $button_icon['value'] ) ?>"></i><?php
		}
	}
}