<?php
/**
 * Trait RHEA_Properties_Action_buttons
 *
 * Trait for properties widgets partials
 *
 * @since 2.4.0
 */
trait RHEA_Properties_Action_buttons {
	/**
	 * action_buttons_labels
	 *
	 * Add labels controls for action button
	 *
	 * @since 2.4.0
	 */
	public function action_buttons_labels() {

		$this->add_control(
			'ere_property_fav_label',
			[
				'label'   => esc_html__( 'Add To Favourite', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Add To Favourite', RHEA_TEXT_DOMAIN ),
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'ere_property_fav_added_label',
			[
				'label'   => esc_html__( 'Added To Favourite', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Added To Favourite', RHEA_TEXT_DOMAIN ),
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'ere_property_compare_label',
			[
				'label'   => esc_html__( 'Add To Compare', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Add To Compare', RHEA_TEXT_DOMAIN ),
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'ere_property_compare_added_label',
			[
				'label'   => esc_html__( 'Added To Compare', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Added To Compare', RHEA_TEXT_DOMAIN ),
				'frontend_available' => true,
			]
		);
	}

	/**
	 * inline_action_buttons_labels
	 *
	 * Action Buttons Labels Controls To Be Displayed Inline
	 *
	 * @since 2.4.0
	 */
	public function inline_action_buttons_labels() {

		$this->add_control(
			'favourite_button_label',
			[
				'label'   => esc_html__( 'Favourite Button', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Favourite', RHEA_TEXT_DOMAIN ),
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'compare_button_label',
			[
				'label'   => esc_html__( 'Compare Button', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Compare', RHEA_TEXT_DOMAIN ),
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'images_button_label',
			[
				'label'   => esc_html__( 'Images Button', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Images', RHEA_TEXT_DOMAIN ),
				'frontend_available' => true,
			]
		);

		$this->add_control(
			'videos_button_label',
			[
				'label'   => esc_html__( 'Videos Button', RHEA_TEXT_DOMAIN ),
				'type'    => \Elementor\Controls_Manager::TEXT,
				'default' => esc_html__( 'Videos', RHEA_TEXT_DOMAIN ),
				'frontend_available' => true,
			]
		);
	}

	/**
	 * render_favourite_button
	 *
	 * Generate Markup For Favourite Buttons
	 *
	 * @since 2.4.0
	 */
	public function render_favourite_button( $property_id, $settings, $icon_path = '', $design_variation = '' ) {

		$fav_button = get_option( 'theme_enable_fav_button' );

		if ( 'true' === $fav_button && 'yes' === $settings['ere_enable_fav_properties'] ) {

			$require_login                       = get_option( 'inspiry_login_on_fav', 'no' );
			$inspiry_add_to_fav_property_label   = get_option( 'inspiry_add_to_fav_property_label' );
			$inspiry_added_to_fav_property_label = get_option( 'inspiry_added_to_fav_property_label' );

			if ( ! empty( $settings['ere_property_fav_label'] ) ) {
				$add_label = $settings['ere_property_fav_label'];
			} else if ( $inspiry_add_to_fav_property_label ) {
				$add_label = $inspiry_add_to_fav_property_label;
			} else {
				$add_label = esc_html__( 'Add to favorites', RHEA_TEXT_DOMAIN );
			}

			if ( ! empty( $settings['ere_property_fav_added_label'] ) ) {
				$added_label = $settings['ere_property_fav_added_label'];
			} else if ( $inspiry_added_to_fav_property_label ) {
				$added_label = $inspiry_added_to_fav_property_label;
			} else {
				$added_label = esc_html__( 'Added to favorites', RHEA_TEXT_DOMAIN );
			}

			$tooltip_class            = '';
			$added_tooltip_attributes = ' data-tooltip="' . esc_attr( $added_label ) . '" ';
			$add_tooltip_attributes   = ' data-tooltip="' . esc_attr( $add_label ) . '" ';
			if ( 'ultra' === $design_variation ) {
				$tooltip_class            = ' rh-ui-tooltip ';
				$added_tooltip_attributes = ' title="' . esc_attr( $added_label ) . '" ';
				$add_tooltip_attributes   = ' title="' . esc_attr( $add_label ) . '" ';
			}

			$button_label = ( array_key_exists( 'favourite_button_label', $settings ) && ! empty( $settings['favourite_button_label'] ) ) ? $settings['favourite_button_label'] : '';

			if ( ( is_user_logged_in() && 'yes' === $require_login ) || ( 'yes' !== $require_login ) ) {

				$user_status = 'user_not_logged_in';
				if ( is_user_logged_in() ) {
					$user_status = 'user_logged_in';
				}


				if ( is_added_to_favorite( $property_id ) ) {
					?>
                    <span class="favorite-btn-wrap favorite-btn-<?php echo esc_attr( $property_id ); ?>">
							<span class="favorite-placeholder highlight__red <?php echo esc_attr( $user_status . $tooltip_class ); ?>" data-propertyid="<?php echo esc_attr( $property_id ); ?>" <?php echo $added_tooltip_attributes ?>>
								<?php
								inspiry_include_favorite_svg_icon( $icon_path );
								echo esc_html( $button_label );
								?>

							</span>
							<a href="#" class="favorite add-to-favorite hide <?php echo esc_attr( $user_status . $tooltip_class ); ?>" data-propertyid="<?php echo esc_attr( $property_id ); ?>" <?php echo $add_tooltip_attributes ?>>
								<?php
								inspiry_include_favorite_svg_icon( $icon_path );
								echo esc_html( $button_label );
								?>
							</a>
						</span>
					<?php
				} else {
					?>
                    <span class="favorite-btn-wrap favorite-btn-<?php echo esc_attr( $property_id ); ?>">
							<span class="favorite-placeholder highlight__red hide <?php echo esc_attr( $user_status . $tooltip_class ); ?>" data-propertyid="<?php echo esc_attr( $property_id ); ?>" <?php echo $added_tooltip_attributes ?>>
								<?php
								inspiry_include_favorite_svg_icon( $icon_path );
								echo esc_html( $button_label );
								?>
							</span>
							<a href="#" class="favorite add-to-favorite <?php echo esc_attr( $user_status . $tooltip_class ); ?>" data-propertyid="<?php echo esc_attr( $property_id ); ?>" <?php echo $add_tooltip_attributes ?>>
								<?php
								inspiry_include_favorite_svg_icon( $icon_path );
								echo esc_html( $button_label );
								?>
							</a>
						</span>
					<?php
				}
			} else {
				?>
                <a href="#" class="<?php echo esc_attr( $tooltip_class ) ?> favorite add-to-favorite require-login" data-login="<?php echo esc_url( inspiry_get_login_register_url() ); ?>" <?php echo $add_tooltip_attributes ?>>
					<?php
					inspiry_include_favorite_svg_icon( $icon_path );
					echo esc_html( $button_label );
					?>
                </a>
				<?php
			}
		}
	}

	/**
	 * generate_compare_icon
	 *
	 * Generate Compare Button Icon
	 *
	 * @since 2.4.0
	 */
	private function generate_compare_icon() {

		if ( ! RealHomes_Render_Icons::realhomes_custom_icons( 'realhomes_compare_button_icon' ) ) {
			include RHEA_ASSETS_DIR . 'icons/ultra-compare.svg';
		}
	}

	/**
	 * render_compare_button
	 *
	 * Render Compare Icon
	 *
	 * @since 2.4.0
	 *
	 * @param int    $property_id Property ID.
	 * @param array  $settings    Controls Settings.
	 * @param string $class       Container Class Selector.
	 */
	public function render_compare_button( $property_id, $settings, $class = '' ) {
		$compare_properties_module = get_option( 'theme_compare_properties_module' );
		$inspiry_compare_page      = get_option( 'inspiry_compare_page' );
		if ( 'enable' === $compare_properties_module && $inspiry_compare_page && 'yes' == $settings['ere_enable_compare_properties'] ) {
			$property_img_url = get_the_post_thumbnail_url( $property_id, 'property-thumb-image' );
			if ( empty( $property_img_url ) ) {
				$property_img_url = get_inspiry_image_placeholder_url( 'property-thumb-image' );
			}

			$button_label = ( array_key_exists( 'compare_button_label', $settings ) && ! empty( $settings['compare_button_label'] ) ) ? $settings['compare_button_label'] : '';
			?>
            <div class="add-to-compare-span rhea_compare_icons rhea_svg_fav_icons compare-btn-<?php echo esc_attr( $property_id . ' ' . $class ); ?>" data-property-id="<?php echo esc_attr( $property_id ); ?>" data-property-title="<?php echo esc_attr( get_the_title( $property_id ) ); ?>" data-property-url="<?php echo esc_url( get_the_permalink( $property_id ) ); ?>" data-property-image="<?php echo esc_url( $property_img_url ); ?>">
                <span class="compare-placeholder highlight hide rh-ui-tooltip" title="<?php echo esc_attr( $settings['ere_property_compare_added_label'] ); ?>">
                    <?php
                    $this->generate_compare_icon();
	                echo esc_html( $button_label );
                    ?>
                </span>
                <a class="rh_trigger_compare rhea_add_to_compare rh-ui-tooltip" title="<?php echo esc_attr( $settings['ere_property_compare_label'] ); ?>" href="<?php echo esc_url( get_the_permalink( $property_id ) ); ?>">
                    <?php
                    $this->generate_compare_icon();
					echo esc_html( $button_label );
                    ?>
                </a>
            </div>
			<?php
		}
	}

	/**
	 * render_media_count_button
	 *
	 * Generate Markup for Media Count Buttons
	 *
	 * @since 2.4.0
	 *
	 * @param int    $property_id Property ID.
	 * @param string $widget_id   Widget ID.
	 * @param array  $settings    Settings.
	 * @param bool   $tooltip     Enable Tooltip.
	 * @param string $class       Container Class Selector.
	 */
	public function render_media_count_button( $property_id, $widget_id, $settings, $tooltip = false, $class = '' ) {


		$get_post_meta_image = get_post_meta( $property_id, 'REAL_HOMES_property_images', false );
		$count_images        = ! empty( $get_post_meta_image ) ? count( $get_post_meta_image ) : '';
		$tooltip_class       = $tooltip ? 'rh-ui-tooltip' : '';
		?>
        <div class="rhea_ultra_media_count <?php echo esc_attr( $class ) ?>">
			<?php
			if ( $count_images > 0 ) {
				if ( array_key_exists( 'images_button_label', $settings ) && ! empty( $settings['images_button_label'] ) ) {
					$title = esc_attr( $count_images . ' ' . $settings['images_button_label'] );
					$label = esc_html( $settings['images_button_label'] );
				} else {
					$title = esc_attr( $count_images . ' ' . __( 'Images', RHEA_TEXT_DOMAIN ) );
					$label = '<span>' . esc_html( $count_images ) . '</span>';
				}
				?>
                <div class="rhea_media rhea_media_image <?php echo esc_attr( $tooltip_class ) ?>" title="<?php echo $title; ?>" data-fancybox-trigger="gallery-<?php echo esc_attr( $widget_id ) . '-' . esc_attr( $property_id ); ?>" data-this-id="<?php echo esc_attr( $property_id ); ?>">
					<?php
					if ( ! RealHomes_Render_Icons::realhomes_custom_icons( 'realhomes_image_button_icon' ) ) {
						include RHEA_ASSETS_DIR . 'icons/photos.svg';
					}
					echo wp_kses( $label, array( 'span' => array() ) );
					?>
                </div>
				<?php
			}

			$inspiry_video_group = get_post_meta( $property_id, 'inspiry_video_group', true );
			$count_videos        = ! empty( $inspiry_video_group ) ? count( $inspiry_video_group ) : '';

			if ( $count_videos > 0 ) {

				if ( array_key_exists( 'videos_button_label', $settings ) && ! empty( $settings['videos_button_label'] ) ) {
					$title = esc_attr( $count_videos . ' ' . $settings['videos_button_label'] );
					$label = esc_html( $settings['videos_button_label'] );
				} else {
					$title = esc_attr( $count_videos . ' ' . __( 'Videos', RHEA_TEXT_DOMAIN ) );
					$label = '<span>' . esc_html( $count_videos ) . '</span>';
				}

				?>
                <div class="rhea_media rhea_media_video <?php echo esc_attr( $tooltip_class ) ?>" title="<?php echo esc_attr( $title ) ?>" data-fancybox-trigger="video-<?php echo esc_attr( $widget_id ) . '-' . esc_attr( $property_id ); ?>" data-this-id="<?php echo esc_attr( $property_id ); ?>">
					<?php
					if ( ! RealHomes_Render_Icons::realhomes_custom_icons( 'realhomes_video_button_icon' ) ) {
						include RHEA_ASSETS_DIR . 'icons/video.svg';
					}
					echo wp_kses( $label, array( 'span' => array() ) );
					?>
                </div>
				<?php
			}
			?>
        </div>
        <div class="rhea_property_images_load" style="display: none">
			<?php
			if ( ! empty( $get_post_meta_image ) ) {
				foreach ( $get_post_meta_image as $item ) {
					$images_src = wp_get_attachment_image_src( $item, 'post-featured-image' );
					if ( isset( $images_src[0] ) ) {
						?>
                        <span style="display: none;" data-fancybox="gallery-<?php echo esc_attr( $widget_id ) . '-' . esc_attr( $property_id ); ?>" data-src="<?php echo esc_url( $images_src[0] ); ?>" data-thumb="<?php echo esc_url( $images_src[0] ); ?>"></span>
						<?php
					}
				}
			}

			if ( ! empty( $inspiry_video_group ) ) {
				foreach ( $inspiry_video_group as $video ) {
					?>
                    <span style="display: none;" data-fancybox="video-<?php echo esc_attr( $widget_id ) . '-' . esc_attr( $property_id ); ?>" data-src="<?php echo esc_url( $video['inspiry_video_group_url'] ); ?>"></span>
					<?php
				}
			}
			?>
        </div>
		<?php
	}

}